/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.simple;

import com.yahoo.language.Language;
import com.yahoo.language.LinguisticsCase;
import com.yahoo.language.process.Normalizer;
import com.yahoo.language.process.StemMode;
import com.yahoo.language.process.Token;
import com.yahoo.language.process.TokenType;
import com.yahoo.language.process.Tokenizer;
import com.yahoo.language.process.Transformer;
import com.yahoo.language.simple.SimpleNormalizer;
import com.yahoo.language.simple.SimpleToken;
import com.yahoo.language.simple.SimpleTokenType;
import com.yahoo.language.simple.SimpleTransformer;
import com.yahoo.language.simple.kstem.KStemmer;
import java.util.ArrayList;
import java.util.Collections;

public class SimpleTokenizer
implements Tokenizer {
    private static final int SPACE_CODE = 32;
    private final Normalizer normalizer;
    private final Transformer transformer;
    private final KStemmer stemmer = new KStemmer();

    public SimpleTokenizer() {
        this(new SimpleNormalizer(), new SimpleTransformer());
    }

    public SimpleTokenizer(Normalizer normalizer) {
        this(normalizer, new SimpleTransformer());
    }

    public SimpleTokenizer(Normalizer normalizer, Transformer transformer) {
        this.normalizer = normalizer;
        this.transformer = transformer;
    }

    @Override
    public Iterable<Token> tokenize(String input, Language language, StemMode stemMode, boolean removeAccents) {
        if (input.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Token> tokens = new ArrayList<Token>();
        int nextCode = input.codePointAt(0);
        TokenType prevType = SimpleTokenType.valueOf(nextCode);
        int prev = 0;
        for (int next = Character.charCount(nextCode); next <= input.length(); next += Character.charCount(nextCode)) {
            nextCode = next < input.length() ? input.codePointAt(next) : 32;
            TokenType nextType = SimpleTokenType.valueOf(nextCode);
            if (prevType.isIndexable() && nextType.isIndexable()) continue;
            String original = input.substring(prev, next);
            String token = this.processToken(original, language, stemMode, removeAccents);
            tokens.add(new SimpleToken(original).setOffset(prev).setType(prevType).setTokenString(token));
            prev = next;
            prevType = nextType;
        }
        return tokens;
    }

    private String processToken(String token, Language language, StemMode stemMode, boolean removeAccents) {
        token = this.normalizer.normalize(token);
        token = LinguisticsCase.toLowerCase(token);
        if (removeAccents) {
            token = this.transformer.accentDrop(token, language);
        }
        if (stemMode != StemMode.NONE) {
            token = this.stemmer.stem(token);
        }
        return token;
    }
}

