/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.opennlp;

import com.yahoo.language.Language;
import com.yahoo.language.LinguisticsCase;
import com.yahoo.language.process.Normalizer;
import com.yahoo.language.process.StemMode;
import com.yahoo.language.process.Token;
import com.yahoo.language.process.TokenType;
import com.yahoo.language.process.Tokenizer;
import com.yahoo.language.process.Transformer;
import com.yahoo.language.simple.SimpleNormalizer;
import com.yahoo.language.simple.SimpleToken;
import com.yahoo.language.simple.SimpleTokenType;
import com.yahoo.language.simple.SimpleTokenizer;
import com.yahoo.language.simple.SimpleTransformer;
import java.util.ArrayList;
import java.util.Collections;
import opennlp.tools.stemmer.Stemmer;
import opennlp.tools.stemmer.snowball.SnowballStemmer;

public class OpenNlpTokenizer
implements Tokenizer {
    private static final int SPACE_CODE = 32;
    private final Normalizer normalizer;
    private final Transformer transformer;
    private final SimpleTokenizer simpleTokenizer;

    public OpenNlpTokenizer() {
        this(new SimpleNormalizer(), new SimpleTransformer());
    }

    public OpenNlpTokenizer(Normalizer normalizer, Transformer transformer) {
        this.normalizer = normalizer;
        this.transformer = transformer;
        this.simpleTokenizer = new SimpleTokenizer(normalizer, transformer);
    }

    @Override
    public Iterable<Token> tokenize(String input, Language language, StemMode stemMode, boolean removeAccents) {
        if (input.isEmpty()) {
            return Collections.emptyList();
        }
        Stemmer stemmer = this.getStemmerForLanguage(language, stemMode);
        if (stemmer == null) {
            return this.simpleTokenizer.tokenize(input, language, stemMode, removeAccents);
        }
        ArrayList<Token> tokens = new ArrayList<Token>();
        int nextCode = input.codePointAt(0);
        TokenType prevType = SimpleTokenType.valueOf(nextCode);
        int prev = 0;
        for (int next = Character.charCount(nextCode); next <= input.length(); next += Character.charCount(nextCode)) {
            nextCode = next < input.length() ? input.codePointAt(next) : 32;
            TokenType nextType = SimpleTokenType.valueOf(nextCode);
            if (prevType.isIndexable() && nextType.isIndexable()) continue;
            String original = input.substring(prev, next);
            String token = this.processToken(original, language, stemMode, removeAccents, stemmer);
            tokens.add(new SimpleToken(original).setOffset(prev).setType(prevType).setTokenString(token));
            prev = next;
            prevType = nextType;
        }
        return tokens;
    }

    private Stemmer getStemmerForLanguage(Language language, StemMode stemMode) {
        SnowballStemmer.ALGORITHM alg;
        if (language == null || Language.ENGLISH.equals((Object)language) || StemMode.NONE.equals((Object)stemMode)) {
            return null;
        }
        switch (language) {
            case DANISH: {
                alg = SnowballStemmer.ALGORITHM.DANISH;
                break;
            }
            case DUTCH: {
                alg = SnowballStemmer.ALGORITHM.DUTCH;
                break;
            }
            case FINNISH: {
                alg = SnowballStemmer.ALGORITHM.FINNISH;
                break;
            }
            case FRENCH: {
                alg = SnowballStemmer.ALGORITHM.FRENCH;
                break;
            }
            case GERMAN: {
                alg = SnowballStemmer.ALGORITHM.GERMAN;
                break;
            }
            case HUNGARIAN: {
                alg = SnowballStemmer.ALGORITHM.HUNGARIAN;
                break;
            }
            case IRISH: {
                alg = SnowballStemmer.ALGORITHM.IRISH;
                break;
            }
            case ITALIAN: {
                alg = SnowballStemmer.ALGORITHM.ITALIAN;
                break;
            }
            case NORWEGIAN_BOKMAL: 
            case NORWEGIAN_NYNORSK: {
                alg = SnowballStemmer.ALGORITHM.NORWEGIAN;
                break;
            }
            case PORTUGUESE: {
                alg = SnowballStemmer.ALGORITHM.PORTUGUESE;
                break;
            }
            case ROMANIAN: {
                alg = SnowballStemmer.ALGORITHM.ROMANIAN;
                break;
            }
            case RUSSIAN: {
                alg = SnowballStemmer.ALGORITHM.RUSSIAN;
                break;
            }
            case SPANISH: {
                alg = SnowballStemmer.ALGORITHM.SPANISH;
                break;
            }
            case SWEDISH: {
                alg = SnowballStemmer.ALGORITHM.SWEDISH;
                break;
            }
            case TURKISH: {
                alg = SnowballStemmer.ALGORITHM.TURKISH;
                break;
            }
            case ENGLISH: {
                alg = SnowballStemmer.ALGORITHM.ENGLISH;
                break;
            }
            default: {
                return null;
            }
        }
        return new SnowballStemmer(alg);
    }

    private String processToken(String token, Language language, StemMode stemMode, boolean removeAccents, Stemmer stemmer) {
        token = this.normalizer.normalize(token);
        token = LinguisticsCase.toLowerCase(token);
        if (removeAccents) {
            token = this.transformer.accentDrop(token, language);
        }
        if (stemMode != StemMode.NONE) {
            token = this.doStemming(token, stemmer);
        }
        return token;
    }

    private String doStemming(String token, Stemmer stemmer) {
        return stemmer.stem((CharSequence)token).toString();
    }
}

