/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.simple;

import com.yahoo.language.Language;
import com.yahoo.language.LinguisticsCase;
import com.yahoo.language.process.Normalizer;
import com.yahoo.language.process.SpecialTokenRegistry;
import com.yahoo.language.process.StemMode;
import com.yahoo.language.process.Token;
import com.yahoo.language.process.TokenType;
import com.yahoo.language.process.Tokenizer;
import com.yahoo.language.process.Transformer;
import com.yahoo.language.simple.SimpleNormalizer;
import com.yahoo.language.simple.SimpleToken;
import com.yahoo.language.simple.SimpleTokenType;
import com.yahoo.language.simple.SimpleTransformer;
import com.yahoo.language.simple.kstem.KStemmer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimpleTokenizer
implements Tokenizer {
    private static final Logger log = Logger.getLogger(SimpleTokenizer.class.getName());
    private static final int SPACE_CODE = 32;
    private final Normalizer normalizer;
    private final Transformer transformer;
    private final KStemmer stemmer = new KStemmer();
    private final SpecialTokenRegistry specialTokenRegistry;

    public SimpleTokenizer() {
        this(new SimpleNormalizer(), new SimpleTransformer());
    }

    public SimpleTokenizer(Normalizer normalizer) {
        this(normalizer, new SimpleTransformer());
    }

    public SimpleTokenizer(Normalizer normalizer, Transformer transformer) {
        this(normalizer, transformer, new SpecialTokenRegistry(List.of()));
    }

    public SimpleTokenizer(Normalizer normalizer, Transformer transformer, SpecialTokenRegistry specialTokenRegistry) {
        this.normalizer = normalizer;
        this.transformer = transformer;
        this.specialTokenRegistry = specialTokenRegistry;
    }

    @Override
    public Iterable<Token> tokenize(String input, Language language, StemMode stemMode, boolean removeAccents) {
        if (input.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Token> tokens = new ArrayList<Token>();
        int nextCode = input.codePointAt(0);
        TokenType prevType = SimpleTokenType.valueOf(nextCode);
        int prev = 0;
        for (int next = Character.charCount(nextCode); next <= input.length(); next += Character.charCount(nextCode)) {
            nextCode = next < input.length() ? input.codePointAt(next) : 32;
            TokenType nextType = SimpleTokenType.valueOf(nextCode);
            if (prevType.isIndexable() && nextType.isIndexable()) continue;
            String original = input.substring(prev, next);
            String token = this.processToken(original, language, stemMode, removeAccents);
            tokens.add(new SimpleToken(original).setOffset(prev).setType(prevType).setTokenString(token));
            prev = next;
            prevType = nextType;
        }
        return tokens;
    }

    private String processToken(String token, Language language, StemMode stemMode, boolean removeAccents) {
        String original = token;
        log.log(Level.FINEST, () -> "processToken '" + original + "'");
        token = this.normalizer.normalize(token);
        token = LinguisticsCase.toLowerCase(token);
        if (removeAccents) {
            token = this.transformer.accentDrop(token, language);
        }
        if (stemMode != StemMode.NONE) {
            String oldToken = token;
            String newToken = token = this.stemmer.stem(token);
            log.log(Level.FINEST, () -> "stem '" + oldToken + "' to '" + newToken + "'");
        }
        String result = token;
        log.log(Level.FINEST, () -> "processed token is: " + result);
        return result;
    }
}

