/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.process;

import com.yahoo.language.Language;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import java.util.List;

public interface Embedder {
    public static final Embedder throwsOnUse = new FailingEmbedder();

    public List<Integer> embed(String var1, Context var2);

    public Tensor embed(String var1, Context var2, TensorType var3);

    public static class FailingEmbedder
    implements Embedder {
        @Override
        public List<Integer> embed(String text, Context context) {
            throw new IllegalStateException("No embedder has been configured");
        }

        @Override
        public Tensor embed(String text, Context context, TensorType tensorType) {
            throw new IllegalStateException("No embedder has been configured");
        }
    }

    public static class Context {
        private Language language = Language.UNKNOWN;
        private String destination;

        public Context(String destination) {
            this.destination = destination;
        }

        public Language getLanguage() {
            return this.language;
        }

        public Context setLanguage(Language language) {
            this.language = language;
            return this;
        }

        public String getDestination() {
            return this.destination;
        }

        public Context setDestination(String destination) {
            this.destination = destination;
            return this;
        }
    }
}

