/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.opennlp;

import com.google.common.base.Optional;
import com.optimaize.langdetect.LanguageDetector;
import com.optimaize.langdetect.LanguageDetectorBuilder;
import com.optimaize.langdetect.i18n.LdLocale;
import com.optimaize.langdetect.ngram.NgramExtractor;
import com.optimaize.langdetect.ngram.NgramExtractors;
import com.optimaize.langdetect.profiles.LanguageProfileReader;
import com.optimaize.langdetect.text.CommonTextObjectFactories;
import com.optimaize.langdetect.text.TextObjectFactory;
import com.yahoo.language.Language;
import com.yahoo.language.detect.Detection;
import com.yahoo.language.detect.Detector;
import com.yahoo.language.detect.Hint;
import com.yahoo.language.simple.SimpleDetector;
import com.yahoo.text.Utf8;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OptimaizeDetector
implements Detector {
    private static Object initGuard = new Object();
    private static TextObjectFactory textObjectFactory = null;
    private static LanguageDetector languageDetector = null;
    private static final Logger log = Logger.getLogger(OptimaizeDetector.class.getName());
    private SimpleDetector simpleDetector = new SimpleDetector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initOptimaize() {
        Object object = initGuard;
        synchronized (object) {
            List languageProfiles;
            if (textObjectFactory != null && languageDetector != null) {
                return;
            }
            try {
                languageProfiles = new LanguageProfileReader().readAllBuiltIn();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            languageDetector = LanguageDetectorBuilder.create((NgramExtractor)NgramExtractors.standard()).withProfiles((Iterable)languageProfiles).build();
            textObjectFactory = CommonTextObjectFactories.forDetectingOnLargeText();
        }
    }

    public OptimaizeDetector() {
        OptimaizeDetector.initOptimaize();
    }

    @Override
    public Detection detect(byte[] input, int offset, int length, Hint hint) {
        return new Detection(this.guessLanguage(input, offset, length), this.simpleDetector.guessEncoding(input), false);
    }

    @Override
    public Detection detect(ByteBuffer input, Hint hint) {
        byte[] buf = new byte[input.remaining()];
        input.get(buf, 0, buf.length);
        return this.detect(buf, 0, buf.length, hint);
    }

    @Override
    public Detection detect(String input, Hint hint) {
        return new Detection(this.guessLanguage(input), Utf8.getCharset().name(), false);
    }

    private Language guessLanguage(byte[] buf, int offset, int length) {
        return this.guessLanguage(Utf8.toString((byte[])buf, (int)offset, (int)length));
    }

    public Language guessLanguage(String input) {
        if (input == null || input.length() == 0) {
            return Language.UNKNOWN;
        }
        Language result = this.simpleDetector.guessLanguage(input);
        if (result != Language.UNKNOWN) {
            return result;
        }
        return OptimaizeDetector.guessLanguageUsingOptimaize(input);
    }

    private static Language guessLanguageUsingOptimaize(String input) {
        Optional result = languageDetector.detect((CharSequence)textObjectFactory.forText((CharSequence)input));
        if (!result.isPresent()) {
            return Language.UNKNOWN;
        }
        log.log(Level.FINE, () -> "guessing language " + result.get() + " from input: " + input);
        return Language.fromLocale(new Locale(((LdLocale)result.get()).getLanguage()));
    }
}

