/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.process;

public enum TokenType {
    UNKNOWN(0),
    SPACE(1),
    PUNCTUATION(2),
    SYMBOL(3),
    ALPHABETIC(4),
    NUMERIC(5),
    MARKER(255);

    private final int value;

    private TokenType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isIndexable() {
        switch (this) {
            case ALPHABETIC: 
            case NUMERIC: {
                return true;
            }
        }
        return false;
    }

    public static TokenType valueOf(int value) {
        for (TokenType type : TokenType.values()) {
            if (value != type.value) continue;
            return type;
        }
        return UNKNOWN;
    }
}

