/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.opennlp;

import com.google.inject.Inject;
import com.yahoo.language.detect.Detector;
import com.yahoo.language.opennlp.OpenNlpTokenizer;
import com.yahoo.language.opennlp.OpennlpLinguisticsConfig;
import com.yahoo.language.opennlp.OptimaizeDetector;
import com.yahoo.language.process.Tokenizer;
import com.yahoo.language.simple.SimpleDetector;
import com.yahoo.language.simple.SimpleLinguistics;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OpenNlpLinguistics
extends SimpleLinguistics {
    private static final Logger log = Logger.getLogger(OpenNlpLinguistics.class.getName());
    private final Detector detector;

    public OpenNlpLinguistics() {
        this(true);
    }

    @Inject
    public OpenNlpLinguistics(OpennlpLinguisticsConfig config) {
        this(config.detector().enableOptimaize());
    }

    public OpenNlpLinguistics(boolean enableOptimaize) {
        this(enableOptimaize ? new OptimaizeDetector() : new SimpleDetector());
        log.log(Level.FINE, "using " + (enableOptimaize ? "Optimaize" : "Simple") + " detector");
    }

    private OpenNlpLinguistics(Detector detector) {
        this.detector = detector;
    }

    @Override
    public Tokenizer getTokenizer() {
        return new OpenNlpTokenizer(this.getNormalizer(), this.getTransformer());
    }

    @Override
    public Detector getDetector() {
        return this.detector;
    }
}

