/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language;

import com.yahoo.language.LocaleFactory;
import com.yahoo.text.Lowercase;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum Language {
    UNKNOWN("un"),
    ABKHAZIAN("ab"),
    AFAR("aa"),
    AFRIKAANS("af"),
    ALBANIAN("sq"),
    AMHARIC("am"),
    ARABIC("ar"),
    ARMENIAN("hy"),
    ASSAMESE("as"),
    AYMARA("ay"),
    AZERBAIJANI("az"),
    BASHKIR("ba"),
    BASQUE("eu"),
    BENGALI("bn"),
    BHUTANI("dz"),
    BIHARI("bh"),
    BISLAMA("bi"),
    BRETON("br"),
    BUGINESE("bug"),
    BULGARIAN("bg"),
    BURMESE("my"),
    BYELORUSSIAN("be"),
    CAMBODIAN("km"),
    CATALAN("ca"),
    CHEROKEE("chr"),
    CHINESE_SIMPLIFIED("zh-hans"),
    CHINESE_TRADITIONAL("zh-hant"),
    COPTIC("cop"),
    CORSICAN("co"),
    CROATIAN("hr"),
    CZECH("cs"),
    DANISH("da"),
    DIVEHI("div"),
    DUTCH("nl"),
    ENGLISH("en"),
    ESPERANTO("eo"),
    ESTONIAN("et"),
    FAROESE("fo"),
    FIJI("fj"),
    FINNISH("fi"),
    FRENCH("fr"),
    FRISIAN("fy"),
    GALICIAN("gl"),
    GEORGIAN("ka"),
    GERMAN("de"),
    GOTHIC("got"),
    GREEK("el"),
    GREENLANDIC("kl"),
    GUARANI("gn"),
    GUJARATI("gu"),
    HAUSA("ha"),
    HEBREW("he"),
    HINDI("hi"),
    HUNGARIAN("hu"),
    ICELANDIC("is"),
    INDONESIAN("id"),
    INTERLINGUA("ia"),
    INTERLINGUE("ie"),
    INUKTITUT("iu"),
    INUPIAK("ik"),
    IRISH("ga"),
    ITALIAN("it"),
    JAPANESE("ja"),
    JAVANESE("jw"),
    KANNADA("kn"),
    KASHMIRI("ks"),
    KAZAKH("kk"),
    KINYARWANDA("rw"),
    KIRGHIZ("ky"),
    KIRUNDI("rn"),
    KOREAN("ko"),
    KURDISH("ku"),
    LAOTHIAN("lo"),
    LATIN("la"),
    LATVIAN("lv"),
    LINGALA("ln"),
    LITHUANIAN("lt"),
    MACEDONIAN("mk"),
    MALAGASY("mg"),
    MALAY("ms"),
    MALAYALAM("ml"),
    MALTESE("mt"),
    MANIPURI("mni"),
    MAORI("mi"),
    MARATHI("mr"),
    MOLDAVIAN("mo"),
    MONGOLIAN("mn"),
    MUNDA("mun"),
    NAURU("na"),
    NEPALI("ne"),
    NORWEGIAN_BOKMAL("nb"),
    NORWEGIAN_NYNORSK("nn"),
    OCCITAN("oc"),
    ORIYA("or"),
    OROMO("om"),
    PASHTO("ps"),
    PERSIAN("fa"),
    POLISH("pl"),
    PORTUGUESE("pt"),
    PUNJABI("pa"),
    QUECHUA("qu"),
    RHAETO_ROMANCE("rm"),
    ROMANIAN("ro"),
    RUSSIAN("ru"),
    SAMOAN("sm"),
    SANGHO("sg"),
    SANSKRIT("sa"),
    SCOTS_GAELIC("gd"),
    SERBIAN("sr"),
    SERBO_CROATIAN("sh"),
    SESOTHO("st"),
    SETSWANA("tn"),
    SHONA("sn"),
    SICHUAN_YI("ii"),
    SINDHI("sd"),
    SINHALESE("si"),
    SISWATI("ss"),
    SLOVAK("sk"),
    SLOVENIAN("sl"),
    SOMALI("so"),
    SPANISH("es"),
    SUNDANESE("su"),
    SWAHILI("sw"),
    SWEDISH("sv"),
    SYRIAC("syr"),
    TAGALOG("fil"),
    TAJIK("tg"),
    TAMIL("ta"),
    TATAR("tt"),
    TELUGU("te"),
    THAI("th"),
    TIBETAN("bo"),
    TIGRINYA("ti"),
    TONGA("to"),
    TSONGA("ts"),
    TURKISH("tr"),
    TURKMEN("tk"),
    TWI("tw"),
    UGARITIC("uga"),
    UIGHUR("ug"),
    UKRAINIAN("uk"),
    URDU("ur"),
    UZBEK("uz"),
    VIETNAMESE("vi"),
    VOLAPUK("vo"),
    WELSH("cy"),
    WOLOF("wo"),
    XHOSA("xh"),
    YIDDISH("yi"),
    YORUBA("yo"),
    ZHUANG("za"),
    ZULU("zu");

    private static final Map<String, Language> index;
    private final String code;

    private Language(String code) {
        this.code = code;
    }

    public String languageCode() {
        return this.code;
    }

    public boolean isCjk() {
        switch (this) {
            case CHINESE_SIMPLIFIED: 
            case CHINESE_TRADITIONAL: 
            case JAPANESE: 
            case KOREAN: 
            case THAI: {
                return true;
            }
        }
        return false;
    }

    public static Language fromLanguageTag(String languageTag) {
        if (languageTag == null) {
            return UNKNOWN;
        }
        return Language.fromLocale(LocaleFactory.fromLanguageTag(languageTag));
    }

    public static Language fromLocale(Locale locale) {
        String str = locale.getLanguage();
        if (str.equals("in")) {
            return INDONESIAN;
        }
        if (str.equals("iw")) {
            return HEBREW;
        }
        if (str.equals("ji")) {
            return YIDDISH;
        }
        if (str.equals("no")) {
            return NORWEGIAN_BOKMAL;
        }
        if (str.equals("zh")) {
            if (locale.getCountry().equalsIgnoreCase("cn") || locale.getVariant().equalsIgnoreCase("hans")) {
                return CHINESE_SIMPLIFIED;
            }
            return CHINESE_TRADITIONAL;
        }
        Language ret = index.get(str);
        return ret != null ? ret : UNKNOWN;
    }

    public static Language fromEncoding(String encoding) {
        if (encoding == null) {
            return UNKNOWN;
        }
        return Language.fromLowerCasedEncoding(Lowercase.toLowerCase((String)encoding));
    }

    private static Language fromLowerCasedEncoding(String encoding) {
        if (encoding.equals("gb2312")) {
            return CHINESE_SIMPLIFIED;
        }
        if (encoding.equals("big5")) {
            return CHINESE_TRADITIONAL;
        }
        if (encoding.equals("euc-jp") || encoding.equals("iso-2022-jp") || encoding.equals("shift-jis")) {
            return JAPANESE;
        }
        if (encoding.equals("euc-kr")) {
            return KOREAN;
        }
        return UNKNOWN;
    }

    static {
        index = new HashMap<String, Language>();
        for (Language language : Language.values()) {
            index.put(language.code, language);
        }
    }
}

