/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.simple;

import com.yahoo.language.process.Token;
import com.yahoo.language.process.TokenScript;
import com.yahoo.language.process.TokenType;
import java.util.ArrayList;
import java.util.List;

public class SimpleToken
implements Token {
    private final List<Token> components = new ArrayList<Token>();
    private final String orig;
    private TokenType type = TokenType.UNKNOWN;
    private TokenScript script = TokenScript.UNKNOWN;
    private String tokenString = null;
    private boolean specialToken = false;
    private long offset = 0L;

    public SimpleToken(String orig) {
        this.orig = orig;
    }

    @Override
    public String getOrig() {
        return this.orig;
    }

    @Override
    public int getNumStems() {
        return this.tokenString != null ? 1 : 0;
    }

    @Override
    public String getStem(int i) {
        return this.tokenString;
    }

    @Override
    public int getNumComponents() {
        return this.components.size();
    }

    @Override
    public Token getComponent(int i) {
        return this.components.get(i);
    }

    public SimpleToken addComponent(Token token) {
        this.components.add(token);
        return this;
    }

    @Override
    public String getTokenString() {
        return this.tokenString;
    }

    public SimpleToken setTokenString(String str) {
        this.tokenString = str;
        return this;
    }

    @Override
    public TokenType getType() {
        return this.type;
    }

    public SimpleToken setType(TokenType type) {
        this.type = type;
        return this;
    }

    @Override
    public TokenScript getScript() {
        return this.script;
    }

    public SimpleToken setScript(TokenScript script) {
        this.script = script;
        return this;
    }

    @Override
    public boolean isSpecialToken() {
        return this.specialToken;
    }

    public SimpleToken setSpecialToken(boolean specialToken) {
        this.specialToken = specialToken;
        return this;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    public SimpleToken setOffset(long offset) {
        this.offset = offset;
        return this;
    }

    public int hashCode() {
        return this.orig.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Token)) {
            return false;
        }
        Token rhs = (Token)obj;
        if (!this.getType().equals((Object)rhs.getType())) {
            return false;
        }
        if (!SimpleToken.equalsOpt(this.getOrig(), rhs.getOrig())) {
            return false;
        }
        if (this.getOffset() != rhs.getOffset()) {
            return false;
        }
        if (!SimpleToken.equalsOpt((Object)this.getScript(), (Object)rhs.getScript())) {
            return false;
        }
        if (!SimpleToken.equalsOpt(this.getTokenString(), rhs.getTokenString())) {
            return false;
        }
        if (this.isSpecialToken() != rhs.isSpecialToken()) {
            return false;
        }
        if (this.getNumComponents() != rhs.getNumComponents()) {
            return false;
        }
        int len = this.getNumComponents();
        for (int i = 0; i < len; ++i) {
            if (SimpleToken.equalsOpt(this.getComponent(i), rhs.getComponent(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsOpt(Object lhs, Object rhs) {
        if (lhs == null || rhs == null) {
            return lhs == rhs;
        }
        return lhs.equals(rhs);
    }

    public String toString() {
        return "token : " + this.getClass().getSimpleName() + " {\n" + SimpleToken.toString(this, "    ") + "}";
    }

    private static String toString(Token token, String indent) {
        StringBuilder builder = new StringBuilder();
        builder.append(indent).append("components : {\n");
        int len = token.getNumComponents();
        for (int i = 0; i < len; ++i) {
            Token comp = token.getComponent(i);
            builder.append(indent).append("    [").append(i).append("] : ").append(comp.getClass().getSimpleName());
            builder.append(" {\n").append(SimpleToken.toString(comp, indent + "        "));
            builder.append(indent).append("    }\n");
        }
        builder.append(indent).append("}\n");
        builder.append(indent).append("offset : ").append(token.getOffset()).append("\n");
        builder.append(indent).append("orig : ").append(SimpleToken.quoteString(token.getOrig())).append("\n");
        builder.append(indent).append("script : ").append((Object)token.getScript()).append("\n");
        builder.append(indent).append("special : ").append(token.isSpecialToken()).append("\n");
        builder.append(indent).append("token string : ").append(SimpleToken.quoteString(token.getTokenString())).append("\n");
        builder.append(indent).append("type : ").append((Object)token.getType()).append("\n");
        return builder.toString();
    }

    private static String quoteString(String str) {
        return str != null ? "'" + str + "'" : null;
    }

    @Override
    public boolean isIndexable() {
        return this.getType().isIndexable() && this.getOrig().length() > 0;
    }
}

