/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.process;

import com.yahoo.language.Language;
import com.yahoo.language.process.Segmenter;
import com.yahoo.language.process.StemMode;
import com.yahoo.language.process.Token;
import com.yahoo.language.process.Tokenizer;
import java.util.ArrayList;
import java.util.List;

public class SegmenterImpl
implements Segmenter {
    private final Tokenizer tokenizer;

    public SegmenterImpl(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    @Override
    public List<String> segment(String input, Language language) {
        ArrayList<String> segments = new ArrayList<String>();
        for (Token token : this.tokenizer.tokenize(input, language, StemMode.NONE, false)) {
            this.findSegments(token, segments);
        }
        if (segments.isEmpty()) {
            segments.add(input);
        }
        return segments;
    }

    private void findSegments(Token token, List<String> out) {
        int len;
        if (token.isSpecialToken() || (len = token.getNumComponents()) == 0) {
            if (token.isIndexable()) {
                out.add(token.getOrig());
            }
        } else {
            for (int i = 0; i < len; ++i) {
                this.findSegments(token.getComponent(i), out);
            }
        }
    }
}

