/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.process;

import com.yahoo.language.process.CharacterClasses;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class GramSplitter {
    private final CharacterClasses characterClasses;

    public GramSplitter(CharacterClasses characterClasses) {
        this.characterClasses = characterClasses;
    }

    public GramSplitterIterator split(String input, int n) {
        if (input == null) {
            throw new NullPointerException("input cannot be null");
        }
        if (n < 1) {
            throw new IllegalArgumentException("n (gram size) cannot be smaller than 1, was " + n);
        }
        return new GramSplitterIterator(input, n, this.characterClasses);
    }

    public static final class Gram {
        private int start;
        private int length;

        public Gram(int start, int length) {
            this.start = start;
            this.length = length;
        }

        public int getStart() {
            return this.start;
        }

        public int getLength() {
            return this.length;
        }

        public String extractFrom(String input) {
            return input.substring(this.start, this.start + this.length);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Gram)) {
                return false;
            }
            Gram gram = (Gram)o;
            if (this.length != gram.length) {
                return false;
            }
            return this.start == gram.start;
        }

        public int hashCode() {
            int result = this.start;
            result = 31 * result + this.length;
            return result;
        }
    }

    public static class GramSplitterIterator
    implements Iterator<Gram> {
        private final CharacterClasses characterClasses;
        private final String input;
        private final int n;
        private int i = 0;
        private boolean isFirstAfterSeparator = true;
        private Gram nextGram = null;

        public GramSplitterIterator(String input, int n, CharacterClasses characterClasses) {
            this.input = input;
            this.n = n;
            this.characterClasses = characterClasses;
        }

        @Override
        public boolean hasNext() {
            if (this.nextGram != null) {
                return true;
            }
            this.nextGram = this.findNext();
            return this.nextGram != null;
        }

        @Override
        public Gram next() {
            Gram currentGram = this.nextGram;
            if (currentGram == null) {
                currentGram = this.findNext();
            }
            if (currentGram == null) {
                throw new NoSuchElementException("No next gram at position " + this.i);
            }
            this.nextGram = null;
            return currentGram;
        }

        private Gram findNext() {
            while (this.i < this.input.length() && !this.characterClasses.isLetterOrDigit(this.input.codePointAt(this.i))) {
                ++this.i;
                this.isFirstAfterSeparator = true;
            }
            if (this.i >= this.input.length()) {
                return null;
            }
            String gram = this.input.substring(this.i, Math.min(this.i + this.n, this.input.length()));
            int nonWordChar = this.indexOfNonWordChar(gram);
            if (nonWordChar == 0) {
                throw new RuntimeException("Programming error");
            }
            if (nonWordChar > 0) {
                gram = gram.substring(0, nonWordChar);
            }
            if (gram.length() == this.n) {
                ++this.i;
                this.isFirstAfterSeparator = false;
                return new Gram(this.i - 1, gram.length());
            }
            if (this.isFirstAfterSeparator) {
                ++this.i;
                this.isFirstAfterSeparator = false;
                return new Gram(this.i - 1, gram.length());
            }
            this.i += gram.length() + 1;
            this.isFirstAfterSeparator = true;
            return this.findNext();
        }

        private int indexOfNonWordChar(String s) {
            for (int i = 0; i < s.length(); ++i) {
                if (this.characterClasses.isLetterOrDigit(s.codePointAt(i))) continue;
                return i;
            }
            return -1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator is read only");
        }

        public List<String> toExtractedList() {
            ArrayList<String> gramList = new ArrayList<String>();
            while (this.hasNext()) {
                gramList.add(this.next().extractFrom(this.input));
            }
            return Collections.unmodifiableList(gramList);
        }
    }
}

