/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.simple;

import com.google.inject.Inject;
import com.yahoo.collections.Tuple2;
import com.yahoo.component.Version;
import com.yahoo.language.Linguistics;
import com.yahoo.language.detect.Detector;
import com.yahoo.language.process.CharacterClasses;
import com.yahoo.language.process.GramSplitter;
import com.yahoo.language.process.Normalizer;
import com.yahoo.language.process.Segmenter;
import com.yahoo.language.process.SegmenterImpl;
import com.yahoo.language.process.Stemmer;
import com.yahoo.language.process.StemmerImpl;
import com.yahoo.language.process.Tokenizer;
import com.yahoo.language.process.Transformer;
import com.yahoo.language.simple.SimpleDetector;
import com.yahoo.language.simple.SimpleLinguisticsConfig;
import com.yahoo.language.simple.SimpleNormalizer;
import com.yahoo.language.simple.SimpleTokenizer;
import com.yahoo.language.simple.SimpleTransformer;

public class SimpleLinguistics
implements Linguistics {
    private final Normalizer normalizer;
    private final Transformer transformer;
    private final Detector detector;
    private final CharacterClasses characterClasses;
    private final GramSplitter gramSplitter;

    @Inject
    public SimpleLinguistics() {
        CharacterClasses characterClasses = new CharacterClasses();
        this.normalizer = new SimpleNormalizer();
        this.transformer = new SimpleTransformer();
        this.detector = new SimpleDetector();
        this.characterClasses = new CharacterClasses();
        this.gramSplitter = new GramSplitter(characterClasses);
    }

    public SimpleLinguistics(SimpleLinguisticsConfig config) {
        CharacterClasses characterClasses = new CharacterClasses();
        this.normalizer = new SimpleNormalizer();
        this.transformer = new SimpleTransformer();
        this.detector = new SimpleDetector(config.detector());
        this.characterClasses = new CharacterClasses();
        this.gramSplitter = new GramSplitter(characterClasses);
    }

    @Override
    public Stemmer getStemmer() {
        return new StemmerImpl(this.getTokenizer());
    }

    @Override
    public Tokenizer getTokenizer() {
        return new SimpleTokenizer(this.normalizer, this.transformer);
    }

    @Override
    public Normalizer getNormalizer() {
        return this.normalizer;
    }

    @Override
    public Transformer getTransformer() {
        return this.transformer;
    }

    @Override
    public Segmenter getSegmenter() {
        return new SegmenterImpl(this.getTokenizer());
    }

    @Override
    public Detector getDetector() {
        return this.detector;
    }

    @Override
    public GramSplitter getGramSplitter() {
        return this.gramSplitter;
    }

    @Override
    public CharacterClasses getCharacterClasses() {
        return this.characterClasses;
    }

    @Override
    public Tuple2<String, Version> getVersion(Linguistics.Component component) {
        return new Tuple2((Object)"yahoo", (Object)new Version(1, 0));
    }
}

