/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.simple;

import com.yahoo.collections.Tuple2;
import com.yahoo.component.Version;
import com.yahoo.language.Linguistics;
import com.yahoo.language.detect.Detector;
import com.yahoo.language.process.CharacterClasses;
import com.yahoo.language.process.GramSplitter;
import com.yahoo.language.process.Normalizer;
import com.yahoo.language.process.Segmenter;
import com.yahoo.language.process.SegmenterImpl;
import com.yahoo.language.process.Stemmer;
import com.yahoo.language.process.StemmerImpl;
import com.yahoo.language.process.Tokenizer;
import com.yahoo.language.process.Transformer;
import com.yahoo.language.simple.SimpleDetector;
import com.yahoo.language.simple.SimpleNormalizer;
import com.yahoo.language.simple.SimpleTokenizer;
import com.yahoo.language.simple.SimpleTransformer;

public class SimpleLinguistics
implements Linguistics {
    private static final Normalizer normalizer = new SimpleNormalizer();
    private static final Transformer transformer = new SimpleTransformer();
    private static final Detector detector = new SimpleDetector();
    private static final CharacterClasses characterClasses = new CharacterClasses();
    private static final GramSplitter gramSplitter = new GramSplitter(characterClasses);

    @Override
    public Stemmer getStemmer() {
        return new StemmerImpl(this.getTokenizer());
    }

    @Override
    public Tokenizer getTokenizer() {
        return new SimpleTokenizer(normalizer, transformer);
    }

    @Override
    public Normalizer getNormalizer() {
        return normalizer;
    }

    @Override
    public Transformer getTransformer() {
        return transformer;
    }

    @Override
    public Segmenter getSegmenter() {
        return new SegmenterImpl(this.getTokenizer());
    }

    @Override
    public Detector getDetector() {
        return detector;
    }

    @Override
    public GramSplitter getGramSplitter() {
        return gramSplitter;
    }

    @Override
    public CharacterClasses getCharacterClasses() {
        return characterClasses;
    }

    @Override
    public Tuple2<String, Version> getVersion(Linguistics.Component component) {
        return new Tuple2((Object)"yahoo", (Object)new Version(1, 0));
    }
}

