/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.sentencepiece;

import com.yahoo.language.sentencepiece.Model;
import com.yahoo.language.sentencepiece.ResultBuilder;
import com.yahoo.language.sentencepiece.Scoring;
import com.yahoo.language.sentencepiece.TokenType;
import com.yahoo.language.sentencepiece.Trie;

class SentencePieceAlgorithm {
    static final char spaceSymbol = '\u2581';
    private final boolean collapseUnknowns;
    private final Scoring scoring;

    SentencePieceAlgorithm(boolean collapseUnknowns, Scoring scoring) {
        this.collapseUnknowns = collapseUnknowns;
        this.scoring = scoring;
    }

    public <RESULTTYPE> void segment(String input, ResultBuilder<RESULTTYPE> resultBuilder, Model model) {
        SegmentEnd[] segmentEnds = new SegmentEnd[input.length() + 1];
        segmentEnds[0] = new SegmentEnd(TokenType.unknown, 0, 0.0f, 0, 0);
        for (int start = 0; start < input.length(); ++start) {
            Trie.Node node = model.tokens.root;
            int characterPosition = start;
            while (node != null && characterPosition < input.length()) {
                node = node.children.get(Character.valueOf(input.charAt(characterPosition++)));
                int length = characterPosition - start;
                if (node != null && node.isToken() && node.type != TokenType.unused) {
                    float score = node.type == TokenType.userDefined ? (float)length * model.maxScore - 0.1f : node.score.floatValue();
                    this.addSegment(TokenType.text, node.id, start, characterPosition, score, segmentEnds);
                    continue;
                }
                if (length != 1) continue;
                this.addSegment(TokenType.unknown, 0, start, start + 1, model.minScore - 10.0f, segmentEnds);
            }
        }
        resultBuilder.build(input, segmentEnds, this.collapseUnknowns);
    }

    private void addSegment(TokenType type, int id, int start, int end, float score, SegmentEnd[] segmentEnds) {
        if (segmentEnds[end] == null || segmentEnds[start].scoreWith(score) > segmentEnds[end].score()) {
            segmentEnds[end] = new SegmentEnd(type, id, segmentEnds[start].pathScoreSum + score, segmentEnds[start].pathSegmentCount + 1, start);
        }
    }

    final class SegmentEnd {
        final TokenType type;
        final int id;
        final float pathScoreSum;
        final int pathSegmentCount;
        final int segmentStart;

        SegmentEnd(TokenType type, int id, float pathScoreSum, int pathSegmentCount, int segmentStart) {
            this.type = type;
            this.id = id;
            this.pathScoreSum = pathScoreSum;
            this.pathSegmentCount = pathSegmentCount;
            this.segmentStart = segmentStart;
        }

        public float score() {
            switch (SentencePieceAlgorithm.this.scoring) {
                case fewestSegments: {
                    return 1.0f / (float)this.pathSegmentCount * 1.0E7f + this.pathScoreSum;
                }
                case highestScore: {
                    return this.pathScoreSum;
                }
            }
            throw new IllegalArgumentException("Unknown scoring " + String.valueOf((Object)SentencePieceAlgorithm.this.scoring));
        }

        public float scoreWith(float additionalSegmentScore) {
            switch (SentencePieceAlgorithm.this.scoring) {
                case fewestSegments: {
                    return 1.0f / (float)(this.pathSegmentCount + 1) * 1.0E7f + (this.pathScoreSum + additionalSegmentScore);
                }
                case highestScore: {
                    return this.pathScoreSum + additionalSegmentScore;
                }
            }
            throw new IllegalArgumentException("Unknown scoring " + String.valueOf((Object)SentencePieceAlgorithm.this.scoring));
        }
    }
}

