/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.huggingface;

import java.util.Arrays;

public record ModelInfo(TruncationStrategy truncation, PaddingStrategy padding, int maxLength, int stride, int padToMultipleOf) {

    public static enum TruncationStrategy {
        LONGEST_FIRST,
        ONLY_FIRST,
        ONLY_SECOND,
        DO_NOT_TRUNCATE;


        public static TruncationStrategy fromString(String v) {
            if ("true".equals(v)) {
                return LONGEST_FIRST;
            }
            if ("false".equals(v)) {
                return DO_NOT_TRUNCATE;
            }
            return Arrays.stream(TruncationStrategy.values()).filter(s -> s.name().equalsIgnoreCase(v)).findAny().orElseThrow(() -> new IllegalArgumentException("Invalid strategy '%s'".formatted(v)));
        }
    }

    public static enum PaddingStrategy {
        LONGEST,
        MAX_LENGTH,
        DO_NOT_PAD;


        public static PaddingStrategy fromString(String v) {
            if ("true".equals(v)) {
                return LONGEST;
            }
            if ("false".equals(v)) {
                return DO_NOT_PAD;
            }
            return Arrays.stream(PaddingStrategy.values()).filter(s -> s.name().equalsIgnoreCase(v)).findAny().orElseThrow(() -> new IllegalArgumentException("Invalid strategy '%s'".formatted(v)));
        }
    }
}

