/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.wordpiece;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.FileReference;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.PathNode;
import com.yahoo.config.StringNode;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class WordPieceConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "b1dfd433baa59a6b8a8f0123769d07b1";
    public static final String CONFIG_DEF_NAME = "word-piece";
    public static final String CONFIG_DEF_NAMESPACE = "language.wordpiece";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=language.wordpiece", "subwordPrefix string default=\"##\"", "model[].language string", "model[].path path"};
    private final StringNode subwordPrefix;
    private final InnerNodeVector<Model> model;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public WordPieceConfig(Builder builder) {
        this(builder, true);
    }

    private WordPieceConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for word-piece must be initialized: " + builder.__uninitialized);
        }
        this.subwordPrefix = builder.subwordPrefix == null ? new StringNode("##") : new StringNode(builder.subwordPrefix);
        this.model = Model.createVector(builder.model);
    }

    public String subwordPrefix() {
        return this.subwordPrefix.value();
    }

    public List<Model> model() {
        return this.model;
    }

    public Model model(int i) {
        return (Model)((Object)this.model.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(WordPieceConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private String subwordPrefix = null;
        public List<Model.Builder> model = new ArrayList<Model.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(WordPieceConfig config) {
            this.subwordPrefix(config.subwordPrefix());
            for (Model m : config.model()) {
                this.model(new Model.Builder(m));
            }
        }

        private Builder override(Builder __superior) {
            if (__superior.subwordPrefix != null) {
                this.subwordPrefix(__superior.subwordPrefix);
            }
            if (!__superior.model.isEmpty()) {
                this.model.addAll(__superior.model);
            }
            return this;
        }

        public Builder subwordPrefix(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.subwordPrefix = __value;
            return this;
        }

        public Builder model(Model.Builder __builder) {
            this.model.add(__builder);
            return this;
        }

        public Builder model(Consumer<Model.Builder> __func) {
            Model.Builder __inner = new Model.Builder();
            __func.accept(__inner);
            this.model.add(__inner);
            return this;
        }

        public Builder model(List<Model.Builder> __builders) {
            this.model = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return WordPieceConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return WordPieceConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return WordPieceConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public WordPieceConfig build() {
            return new WordPieceConfig(this);
        }
    }

    public static final class Model
    extends InnerNode {
        private final StringNode language;
        private final PathNode path;

        public Model(Builder builder) {
            this(builder, true);
        }

        private Model(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for word-piece.model[] must be initialized: " + builder.__uninitialized);
            }
            this.language = builder.language == null ? new StringNode() : new StringNode(builder.language);
            this.path = builder.path == null ? new PathNode() : new PathNode(builder.path);
        }

        public String language() {
            return this.language.value();
        }

        public Path path() {
            return this.path.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Model newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("model");
            return changes;
        }

        private static InnerNodeVector<Model> createVector(List<Builder> builders) {
            ArrayList<Model> elems = new ArrayList<Model>();
            for (Builder b : builders) {
                elems.add(new Model(b));
            }
            return new InnerNodeVector(elems);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("language", "path"));
            private String language = null;
            private FileReference path = null;

            public Builder() {
            }

            public Builder(Model config) {
                this.language(config.language());
                this.path(config.path.getFileReference());
            }

            private Builder override(Builder __superior) {
                if (__superior.language != null) {
                    this.language(__superior.language);
                }
                if (__superior.path != null) {
                    this.path(__superior.path);
                }
                return this;
            }

            public Builder language(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.language = __value;
                this.__uninitialized.remove("language");
                return this;
            }

            public Builder path(FileReference __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.path = __value;
                this.__uninitialized.remove("path");
                return this;
            }

            public Model build() {
                return new Model(this);
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

