/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.Value;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class Int64Array
extends Value {
    private long[] value;

    public Int64Array(long[] value) {
        this.value = value;
    }

    Int64Array(ByteBuffer src) {
        int size = src.getInt();
        this.value = new long[size];
        src.asLongBuffer().get(this.value);
        src.position(src.position() + size * 8);
    }

    @Override
    public byte type() {
        return 76;
    }

    @Override
    public int count() {
        return this.value.length;
    }

    @Override
    int bytes() {
        return 4 + this.value.length * 8;
    }

    @Override
    void encode(ByteBuffer dst) {
        dst.putInt(this.value.length);
        dst.asLongBuffer().put(this.value);
        dst.position(dst.position() + this.value.length * 8);
    }

    @Override
    public long[] asInt64Array() {
        return this.value;
    }

    @Override
    public String toString() {
        return Arrays.toString(this.value);
    }
}

