/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.Value;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class FloatArray
extends Value {
    private float[] value;

    public FloatArray(float[] value) {
        this.value = value;
    }

    FloatArray(ByteBuffer src) {
        int size = src.getInt();
        this.value = new float[size];
        src.asFloatBuffer().get(this.value);
        src.position(src.position() + size * 4);
    }

    @Override
    public byte type() {
        return 70;
    }

    @Override
    public int count() {
        return this.value.length;
    }

    @Override
    int bytes() {
        return 4 + this.value.length * 4;
    }

    @Override
    void encode(ByteBuffer dst) {
        dst.putInt(this.value.length);
        dst.asFloatBuffer().put(this.value);
        dst.position(dst.position() + this.value.length * 4);
    }

    @Override
    public float[] asFloatArray() {
        return this.value;
    }

    @Override
    public String toString() {
        return Arrays.toString(this.value);
    }
}

