/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.Connection;
import com.yahoo.jrt.Queue;
import com.yahoo.jrt.Scheduler;
import com.yahoo.jrt.Task;
import com.yahoo.jrt.Transport;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TransportThread {
    private static final int OPEN = 1;
    private static final int CLOSING = 2;
    private static final int CLOSED = 3;
    private static final Logger log = Logger.getLogger(TransportThread.class.getName());
    private final Transport parent;
    private final Thread thread;
    private final Queue queue;
    private final Queue myQueue;
    private final Scheduler scheduler;
    private int state;
    private final Selector selector;

    private void handleAddConnection(Connection conn) {
        if (conn.isClosed()) {
            if (conn.hasSocket()) {
                this.parent.closeLater(conn);
            }
            return;
        }
        if (!conn.init(this.selector)) {
            this.handleCloseConnection(conn);
        }
    }

    private void handleCloseConnection(Connection conn) {
        if (conn.isClosed()) {
            return;
        }
        conn.fini();
        if (conn.hasSocket()) {
            this.parent.closeLater(conn);
        }
    }

    private void handleEnableWrite(Connection conn) {
        if (conn.isClosed()) {
            return;
        }
        conn.enableWrite();
    }

    private void handleHandshakeWorkDone(Connection conn) {
        if (conn.isClosed()) {
            return;
        }
        try {
            conn.handleHandshakeWorkDone();
        }
        catch (IOException e) {
            conn.setLostReason(e);
            this.handleCloseConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean postCommand(Runnable cmd) {
        int qlen;
        TransportThread transportThread = this;
        synchronized (transportThread) {
            if (this.state == 3) {
                return false;
            }
            this.queue.enqueue(cmd);
            qlen = this.queue.size();
        }
        if (qlen == this.parent.getEventsBeforeWakeup()) {
            this.selector.wakeup();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEvents() {
        TransportThread transportThread = this;
        synchronized (transportThread) {
            this.queue.flush(this.myQueue);
        }
        while (!this.myQueue.isEmpty()) {
            ((Runnable)this.myQueue.dequeue()).run();
        }
    }

    private boolean handleIOEvents(Connection conn, SelectionKey key) {
        if (conn.isClosed()) {
            return true;
        }
        if (key.isReadable()) {
            try {
                conn.handleReadEvent();
            }
            catch (IOException e) {
                conn.setLostReason(e);
                return false;
            }
        }
        if (key.isWritable()) {
            try {
                conn.handleWriteEvent();
            }
            catch (IOException e) {
                conn.setLostReason(e);
                return false;
            }
        }
        return true;
    }

    TransportThread(Transport transport, int index) {
        this.parent = transport;
        this.thread = new Thread((Runnable)new Run(), transport.getName() + ".jrt-transport." + index);
        this.queue = new Queue();
        this.myQueue = new Queue();
        this.scheduler = new Scheduler(System.currentTimeMillis());
        this.state = 1;
        try {
            this.selector = Selector.open();
        }
        catch (Exception e) {
            throw new Error("Could not open transport selector", e);
        }
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public Transport transport() {
        return this.parent;
    }

    void handleFailure(Throwable problem, Object context) {
        this.parent.handleFailure(problem, context);
    }

    void addConnection(Connection conn) {
        if (!this.postCommand(new AddConnectionCmd(conn))) {
            this.perform(new CloseConnectionCmd(conn));
        }
    }

    void closeConnection(Connection conn) {
        this.postCommand(new CloseConnectionCmd(conn));
    }

    void enableWrite(Connection conn) {
        if (Thread.currentThread() == this.thread) {
            this.handleEnableWrite(conn);
        } else {
            this.postCommand(new EnableWriteCmd(conn));
        }
    }

    void handshakeWorkDone(Connection conn) {
        this.postCommand(new HandshakeWorkDoneCmd(conn));
    }

    public Task createTask(Runnable cmd) {
        return new Task(this.scheduler, cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(Runnable cmd) {
        if (Thread.currentThread() == this.thread) {
            cmd.run();
            return;
        }
        if (!this.postCommand(cmd)) {
            this.join();
            Thread thread = this.thread;
            synchronized (thread) {
                cmd.run();
            }
        }
    }

    public void wakeup() {
        this.selector.wakeup();
    }

    public void wakeup_if_not_self() {
        if (Thread.currentThread() != this.thread) {
            this.wakeup();
        }
    }

    public TransportThread sync() {
        SyncCmd cmd = new SyncCmd();
        if (Thread.currentThread() == this.thread) {
            log.log(Level.WARNING, "Attempting to sync " + this.thread + " with itself, which will deadlock");
        }
        if (this.postCommand(cmd)) {
            cmd.waitDone();
        } else {
            this.join();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        Connection conn;
        Iterator<SelectionKey> keys;
        while (this.state == 1) {
            try {
                this.selector.select(100L);
            }
            catch (IOException e) {
                log.log(Level.WARNING, "error during select", e);
            }
            this.handleEvents();
            keys = this.selector.selectedKeys().iterator();
            while (keys.hasNext()) {
                SelectionKey key = keys.next();
                conn = (Connection)key.attachment();
                keys.remove();
                if (this.handleIOEvents(conn, key)) continue;
                this.handleCloseConnection(conn);
            }
            this.scheduler.checkTasks(System.currentTimeMillis());
        }
        keys = this;
        synchronized (keys) {
            this.state = 3;
        }
        this.handleEvents();
        for (SelectionKey key : this.selector.keys()) {
            conn = (Connection)key.attachment();
            this.handleCloseConnection(conn);
        }
        try {
            this.selector.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.parent.notifyDone(this);
    }

    private synchronized void handleShutdown() {
        if (this.state == 1) {
            this.state = 2;
        }
    }

    TransportThread shutdown() {
        this.postCommand(this::handleShutdown);
        return this;
    }

    void join() {
        while (true) {
            try {
                this.thread.join();
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private class Run
    implements Runnable {
        private Run() {
        }

        @Override
        public void run() {
            try {
                TransportThread.this.run();
            }
            catch (Throwable problem) {
                TransportThread.this.handleFailure(problem, TransportThread.this);
            }
        }
    }

    private class AddConnectionCmd
    implements Runnable {
        private final Connection conn;

        AddConnectionCmd(Connection conn) {
            this.conn = conn;
        }

        @Override
        public void run() {
            TransportThread.this.handleAddConnection(this.conn);
        }
    }

    private class CloseConnectionCmd
    implements Runnable {
        private final Connection conn;

        CloseConnectionCmd(Connection conn) {
            this.conn = conn;
        }

        @Override
        public void run() {
            TransportThread.this.handleCloseConnection(this.conn);
        }
    }

    private class EnableWriteCmd
    implements Runnable {
        private final Connection conn;

        EnableWriteCmd(Connection conn) {
            this.conn = conn;
        }

        @Override
        public void run() {
            TransportThread.this.handleEnableWrite(this.conn);
        }
    }

    private class HandshakeWorkDoneCmd
    implements Runnable {
        private final Connection conn;

        HandshakeWorkDoneCmd(Connection conn) {
            this.conn = conn;
        }

        @Override
        public void run() {
            TransportThread.this.handleHandshakeWorkDone(this.conn);
        }
    }

    private static class SyncCmd
    implements Runnable {
        boolean done = false;

        private SyncCmd() {
        }

        public synchronized void waitDone() {
            while (!this.done) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        @Override
        public synchronized void run() {
            this.done = true;
            this.notify();
        }
    }
}

