/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.ErrorPacket;
import com.yahoo.jrt.Packet;
import com.yahoo.jrt.ReplyPacket;
import com.yahoo.jrt.RequestPacket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class PacketInfo {
    private int packetLength;
    private int flags;
    private int packetCode;
    private int requestId;

    private PacketInfo(ByteBuffer src) {
        this.packetLength = src.getInt() + 4;
        this.flags = src.getShort();
        this.packetCode = src.getShort();
        this.requestId = src.getInt();
    }

    PacketInfo(int plen, int flags, int pcode, int reqId) {
        this.packetLength = plen;
        this.flags = flags;
        this.packetCode = pcode;
        this.requestId = reqId;
    }

    public int packetLength() {
        return this.packetLength;
    }

    public int flags() {
        return this.flags;
    }

    public int packetCode() {
        return this.packetCode;
    }

    public int requestId() {
        return this.requestId;
    }

    public boolean reverseByteOrder() {
        return Packet.checkFlag(1, this.flags);
    }

    public boolean noReply() {
        return Packet.checkFlag(2, this.flags);
    }

    public static PacketInfo getPacketInfo(ByteBuffer src) {
        if (src.remaining() < 12) {
            return null;
        }
        return new PacketInfo(src.slice());
    }

    public Packet decodePacket(ByteBuffer src) {
        int pos = src.position();
        int end = pos + this.packetLength;
        int limit = src.limit();
        try {
            src.limit(end);
            src.position(src.position() + 12);
            if (this.reverseByteOrder()) {
                src.order(ByteOrder.LITTLE_ENDIAN);
            }
            switch (this.packetCode) {
                case 100: {
                    RequestPacket requestPacket = new RequestPacket(this.flags, this.requestId, src);
                    return requestPacket;
                }
                case 101: {
                    ReplyPacket replyPacket = new ReplyPacket(this.flags, this.requestId, src);
                    return replyPacket;
                }
                case 102: {
                    ErrorPacket errorPacket = new ErrorPacket(this.flags, this.requestId, src);
                    return errorPacket;
                }
            }
            throw new IllegalArgumentException();
        }
        finally {
            src.order(ByteOrder.BIG_ENDIAN);
            src.position(end);
            src.limit(limit);
        }
    }

    public void encodePacket(Packet packet, ByteBuffer dst) {
        int pos = dst.position();
        int end = pos + this.packetLength;
        int limit = dst.limit();
        try {
            dst.limit(end);
            dst.putInt(this.packetLength - 4);
            dst.putShort((short)this.flags);
            dst.putShort((short)this.packetCode);
            dst.putInt(this.requestId);
            if (this.reverseByteOrder()) {
                dst.order(ByteOrder.LITTLE_ENDIAN);
            }
            packet.encode(dst);
        }
        catch (RuntimeException e) {
            dst.position(pos);
            throw e;
        }
        finally {
            dst.order(ByteOrder.BIG_ENDIAN);
            dst.limit(limit);
        }
    }
}

