/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.Connection;
import com.yahoo.jrt.ErrorPacket;
import com.yahoo.jrt.Method;
import com.yahoo.jrt.ReplyPacket;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.Target;
import com.yahoo.jrt.TieBreaker;

class InvocationServer {
    private Connection conn;
    private Request request;
    private Method method;
    private int replyKey;
    private boolean noReply;
    private TieBreaker done;

    public InvocationServer(Connection conn, Request request, Method method, int replyKey, boolean noReply) {
        this.conn = conn;
        this.request = request;
        this.method = method;
        this.replyKey = replyKey;
        this.noReply = noReply;
        request.serverHandler(this);
        this.done = conn.startRequest();
    }

    public Target getTarget() {
        return this.conn;
    }

    public void invoke() {
        if (this.method != null) {
            if (this.method.checkParameters(this.request)) {
                if (this.method.requestAccessFilter().allow(this.request)) {
                    this.method.invoke(this.request);
                } else {
                    this.request.setError(112, "Permission denied");
                }
            } else {
                this.request.setError(107, "Parameters in " + this.request + " does not match " + this.method);
            }
        } else {
            this.request.setError(106, "No such method");
        }
        if (!this.request.isDetached()) {
            this.returnRequest();
        }
    }

    public void returnRequest() {
        if (!this.conn.completeRequest(this.done)) {
            throw new IllegalStateException("Request already returned");
        }
        if (this.noReply) {
            return;
        }
        if (!this.request.isError() && !this.method.checkReturnValues(this.request)) {
            this.request.setError(109, "Return values in " + this.request + " does not match " + this.method);
        }
        if (this.request.isError()) {
            this.conn.postPacket(new ErrorPacket(0, this.replyKey, this.request.errorCode(), this.request.errorMessage()));
        } else {
            this.conn.postPacket(new ReplyPacket(0, this.replyKey, this.request.returnValues()));
        }
    }
}

