/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.DataArray;
import com.yahoo.jrt.DataValue;
import com.yahoo.jrt.DoubleArray;
import com.yahoo.jrt.DoubleValue;
import com.yahoo.jrt.FloatArray;
import com.yahoo.jrt.FloatValue;
import com.yahoo.jrt.Int16Array;
import com.yahoo.jrt.Int16Value;
import com.yahoo.jrt.Int32Array;
import com.yahoo.jrt.Int32Value;
import com.yahoo.jrt.Int64Array;
import com.yahoo.jrt.Int64Value;
import com.yahoo.jrt.Int8Array;
import com.yahoo.jrt.Int8Value;
import com.yahoo.jrt.StringArray;
import com.yahoo.jrt.StringValue;
import com.yahoo.text.Utf8Array;
import java.nio.ByteBuffer;

public abstract class Value {
    public static final byte INT8 = 98;
    public static final byte INT8_ARRAY = 66;
    public static final byte INT16 = 104;
    public static final byte INT16_ARRAY = 72;
    public static final byte INT32 = 105;
    public static final byte INT32_ARRAY = 73;
    public static final byte INT64 = 108;
    public static final byte INT64_ARRAY = 76;
    public static final byte FLOAT = 102;
    public static final byte FLOAT_ARRAY = 70;
    public static final byte DOUBLE = 100;
    public static final byte DOUBLE_ARRAY = 68;
    public static final byte STRING = 115;
    public static final byte STRING_ARRAY = 83;
    public static final byte DATA = 120;
    public static final byte DATA_ARRAY = 88;

    public abstract byte type();

    public abstract int count();

    abstract int bytes();

    abstract void encode(ByteBuffer var1);

    static Value decode(byte type, ByteBuffer src) {
        switch (type) {
            case 98: {
                return new Int8Value(src);
            }
            case 66: {
                return new Int8Array(src);
            }
            case 104: {
                return new Int16Value(src);
            }
            case 72: {
                return new Int16Array(src);
            }
            case 105: {
                return new Int32Value(src);
            }
            case 73: {
                return new Int32Array(src);
            }
            case 108: {
                return new Int64Value(src);
            }
            case 76: {
                return new Int64Array(src);
            }
            case 102: {
                return new FloatValue(src);
            }
            case 70: {
                return new FloatArray(src);
            }
            case 100: {
                return new DoubleValue(src);
            }
            case 68: {
                return new DoubleArray(src);
            }
            case 115: {
                return new StringValue(src);
            }
            case 83: {
                return new StringArray(src);
            }
            case 120: {
                return new DataValue(src);
            }
            case 88: {
                return new DataArray(src);
            }
        }
        throw new IllegalArgumentException();
    }

    public byte asInt8() {
        throw new ClassCastException();
    }

    public byte[] asInt8Array() {
        throw new ClassCastException();
    }

    public short asInt16() {
        throw new ClassCastException();
    }

    public short[] asInt16Array() {
        throw new ClassCastException();
    }

    public int asInt32() {
        throw new ClassCastException();
    }

    public int[] asInt32Array() {
        throw new ClassCastException();
    }

    public long asInt64() {
        throw new ClassCastException();
    }

    public long[] asInt64Array() {
        throw new ClassCastException();
    }

    public float asFloat() {
        throw new ClassCastException();
    }

    public float[] asFloatArray() {
        throw new ClassCastException();
    }

    public double asDouble() {
        throw new ClassCastException();
    }

    public double[] asDoubleArray() {
        throw new ClassCastException();
    }

    public String asString() {
        throw new ClassCastException();
    }

    public Utf8Array asUtf8Array() {
        throw new ClassCastException();
    }

    public String[] asStringArray() {
        throw new ClassCastException();
    }

    public byte[] asData() {
        throw new ClassCastException();
    }

    public byte[][] asDataArray() {
        throw new ClassCastException();
    }

    public abstract String toString();
}

