/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.CryptoSocket;
import com.yahoo.jrt.TransportMetrics;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class NullCryptoSocket
implements CryptoSocket {
    private final boolean isServer;
    private SocketChannel channel;
    private final TransportMetrics metrics = TransportMetrics.getInstance();

    public NullCryptoSocket(SocketChannel channel, boolean isServer) {
        this.channel = channel;
        this.isServer = isServer;
    }

    @Override
    public SocketChannel channel() {
        return this.channel;
    }

    @Override
    public CryptoSocket.HandshakeResult handshake() throws IOException {
        if (this.isServer) {
            this.metrics.incrementServerUnencryptedConnectionsEstablished();
        } else {
            this.metrics.incrementClientUnencryptedConnectionsEstablished();
        }
        return CryptoSocket.HandshakeResult.DONE;
    }

    @Override
    public void doHandshakeWork() {
    }

    @Override
    public int getMinimumReadBufferSize() {
        return 1;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.channel.read(dst);
    }

    @Override
    public int drain(ByteBuffer dst) throws IOException {
        return 0;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.channel.write(src);
    }

    @Override
    public CryptoSocket.FlushResult flush() throws IOException {
        return CryptoSocket.FlushResult.DONE;
    }

    @Override
    public void dropEmptyBuffers() {
    }
}

