/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.concurrent.CachedThreadPoolWithFallback;
import com.yahoo.jrt.Connection;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

class Connector
implements AutoCloseable {
    private static final Object globalLock = new Object();
    private static CachedThreadPoolWithFallback globalExecutor = null;
    private static long usages = 0L;
    private final AtomicReference<CachedThreadPoolWithFallback> executor = new AtomicReference<CachedThreadPoolWithFallback>(Connector.acquire());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CachedThreadPoolWithFallback acquire() {
        Object object = globalLock;
        synchronized (object) {
            if (globalExecutor == null) {
                globalExecutor = new CachedThreadPoolWithFallback("jrt.connector", 1, 64, 1L, TimeUnit.SECONDS);
            }
            ++usages;
            return globalExecutor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void release(CachedThreadPoolWithFallback executor) {
        Object object = globalLock;
        synchronized (object) {
            assert (executor == globalExecutor);
            if (--usages == 0L) {
                globalExecutor.close();
                globalExecutor = null;
            }
        }
    }

    Connector() {
    }

    private void connect(Connection conn) {
        conn.transportThread().addConnection(conn.connect());
    }

    public void connectLater(Connection conn) {
        Executor executor = (Executor)this.executor.get();
        if (executor != null) {
            try {
                executor.execute(() -> this.connect(conn));
                return;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
        conn.transportThread().addConnection(conn);
    }

    @Override
    public void close() {
        CachedThreadPoolWithFallback toShutdown = this.executor.getAndSet(null);
        if (toShutdown != null) {
            Connector.release(toShutdown);
        }
    }
}

