/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt.slobrok.api;

import com.yahoo.jrt.Int32Value;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.RequestWaiter;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Target;
import com.yahoo.jrt.Task;
import com.yahoo.jrt.Values;
import com.yahoo.jrt.slobrok.api.BackOff;
import com.yahoo.jrt.slobrok.api.BackOffPolicy;
import com.yahoo.jrt.slobrok.api.IMirror;
import com.yahoo.jrt.slobrok.api.SlobrokList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Mirror
implements IMirror {
    private static Logger log = Logger.getLogger(Mirror.class.getName());
    private Supervisor orb;
    private SlobrokList slobroks;
    private String currSlobrok;
    private BackOffPolicy backOff;
    private volatile int updates = 0;
    private boolean requestDone = false;
    private volatile Entry[] specs = new Entry[0];
    private int specsGeneration = 0;
    private Task updateTask = null;
    private RequestWaiter reqWait = null;
    private Target target = null;
    private Request req = null;

    public Mirror(Supervisor orb, SlobrokList slobroks, BackOffPolicy bop) {
        this.orb = orb;
        this.slobroks = slobroks;
        this.backOff = bop;
        this.updateTask = orb.transport().createTask(new Runnable(){

            @Override
            public void run() {
                Mirror.this.checkForUpdate();
            }
        });
        this.reqWait = new RequestWaiter(){

            @Override
            public void handleRequestDone(Request req) {
                Mirror.this.requestDone = true;
                Mirror.this.updateTask.scheduleNow();
            }
        };
        this.updateTask.scheduleNow();
    }

    public Mirror(Supervisor orb, SlobrokList slobroks) {
        this(orb, slobroks, new BackOff());
    }

    public void shutdown() {
        this.updateTask.kill();
        this.orb.transport().perform(new Runnable(){

            @Override
            public void run() {
                Mirror.this.handleShutdown();
            }
        });
    }

    @Override
    public Entry[] lookup(String pattern) {
        ArrayList<Entry> found = new ArrayList<Entry>();
        char[] p = pattern.toCharArray();
        for (Entry specEntry : this.specs) {
            if (!Mirror.match(specEntry.getNameArray(), p)) continue;
            found.add(specEntry);
        }
        return found.toArray(new Entry[found.size()]);
    }

    @Override
    public int updates() {
        return this.updates;
    }

    public boolean ready() {
        return this.updates != 0;
    }

    public boolean connected() {
        return this.target != null;
    }

    static boolean match(char[] name, char[] pattern) {
        int ni = 0;
        int pi = 0;
        while (ni < name.length && pi < pattern.length) {
            if (name[ni] == pattern[pi]) {
                ++ni;
                ++pi;
                continue;
            }
            if (pattern[pi] == '*') {
                ++pi;
                while (ni < name.length && name[ni] != '/') {
                    ++ni;
                }
                if (pi >= pattern.length || pattern[pi] != '*') continue;
                ++pi;
                ni = name.length;
                continue;
            }
            return false;
        }
        while (pi < pattern.length && pattern[pi] == '*') {
            ++pi;
        }
        return ni == name.length && pi == pattern.length;
    }

    private void checkForUpdate() {
        if (this.requestDone) {
            this.handleUpdate();
            this.requestDone = false;
            return;
        }
        if (this.target != null && !this.slobroks.contains(this.currSlobrok)) {
            this.target.close();
            this.target = null;
        }
        if (this.target == null) {
            this.currSlobrok = this.slobroks.nextSlobrokSpec();
            if (this.currSlobrok == null) {
                double delay = this.backOff.get();
                this.updateTask.schedule(delay);
                if (this.backOff.shouldWarn(delay)) {
                    log.log(Level.INFO, "no location brokers available (retry in " + delay + " seconds) for: " + this.slobroks);
                }
                return;
            }
            this.target = this.orb.connect(new Spec(this.currSlobrok));
            this.specsGeneration = 0;
        }
        this.req = new Request("slobrok.incremental.fetch");
        this.req.parameters().add(new Int32Value(this.specsGeneration));
        this.req.parameters().add(new Int32Value(5000));
        this.target.invokeAsync(this.req, 40.0, this.reqWait);
    }

    private void handleUpdate() {
        if (this.req.errorCode() == 0 && this.req.returnValues().satisfies("SSi") && this.req.returnValues().get(0).count() == this.req.returnValues().get(1).count()) {
            Values answer = this.req.returnValues();
            if (this.specsGeneration != answer.get(2).asInt32()) {
                int numNames = answer.get(0).count();
                String[] n = answer.get(0).asStringArray();
                String[] s = answer.get(1).asStringArray();
                Entry[] newSpecs = new Entry[numNames];
                for (int idx = 0; idx < numNames; ++idx) {
                    newSpecs[idx] = new Entry(n[idx], s[idx]);
                }
                this.specs = newSpecs;
                this.specsGeneration = answer.get(2).asInt32();
                int u = this.updates + 1;
                if (u == 0) {
                    ++u;
                }
                this.updates = u;
            }
            this.backOff.reset();
            this.updateTask.schedule(0.1);
            return;
        }
        if (!this.req.checkReturnTypes("iSSSi") || this.req.returnValues().get(2).count() != this.req.returnValues().get(3).count()) {
            log.log(Level.INFO, "Error when handling update from slobrok. Error: " + this.req.errorMessage() + " (error code " + this.req.errorCode() + "), target: " + this.target);
            this.target.close();
            this.target = null;
            this.updateTask.scheduleNow();
            return;
        }
        Values answer = this.req.returnValues();
        int diffFromGeneration = answer.get(0).asInt32();
        int diffToGeneration = answer.get(4).asInt32();
        if (this.specsGeneration != diffToGeneration) {
            Entry[] newSpecs;
            int nRemoves = answer.get(1).count();
            String[] r = answer.get(1).asStringArray();
            int numNames = answer.get(2).count();
            String[] n = answer.get(2).asStringArray();
            String[] s = answer.get(3).asStringArray();
            if (diffFromGeneration == 0) {
                newSpecs = new Entry[numNames];
                for (int idx = 0; idx < numNames; ++idx) {
                    newSpecs[idx] = new Entry(n[idx], s[idx]);
                }
            } else {
                int idx;
                HashMap<String, Entry> map = new HashMap<String, Entry>();
                for (Entry e : this.specs) {
                    map.put(e.getName(), e);
                }
                for (String rem : r) {
                    map.remove(rem);
                }
                for (idx = 0; idx < numNames; ++idx) {
                    map.put(n[idx], new Entry(n[idx], s[idx]));
                }
                newSpecs = new Entry[map.size()];
                idx = 0;
                for (Entry e : map.values()) {
                    newSpecs[idx++] = e;
                }
            }
            this.specs = newSpecs;
            this.specsGeneration = diffToGeneration;
            int u = this.updates + 1;
            if (u == 0) {
                ++u;
            }
            this.updates = u;
        }
        this.backOff.reset();
        this.updateTask.schedule(0.1);
    }

    private void handleShutdown() {
        if (this.req != null) {
            this.req.abort();
            this.req = null;
        }
        if (this.target != null) {
            this.target.close();
            this.target = null;
        }
        this.specs = new Entry[0];
    }

    public static final class Entry
    implements Comparable<Entry> {
        private final String name;
        private final String spec;
        private final char[] nameArray;

        public Entry(String name, String spec) {
            this.name = name;
            this.spec = spec;
            this.nameArray = name.toCharArray();
        }

        public boolean equals(Object rhs) {
            if (rhs == null || !(rhs instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)rhs;
            return this.name.equals(e.name) && this.spec.equals(e.spec);
        }

        public int hashCode() {
            return this.name.hashCode() + this.spec.hashCode();
        }

        @Override
        public int compareTo(Entry b) {
            int diff = this.name.compareTo(b.name);
            return diff != 0 ? diff : this.spec.compareTo(b.spec);
        }

        char[] getNameArray() {
            return this.nameArray;
        }

        public String getName() {
            return this.name;
        }

        public String getSpec() {
            return this.spec;
        }
    }
}

