/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.MethodCreateException;
import com.yahoo.jrt.MethodHandler;
import com.yahoo.jrt.Request;

public class Method {
    private MethodHandler handler;
    private Object object;
    private java.lang.reflect.Method method;
    private String name;
    private String paramTypes;
    private String returnTypes;
    private String desc;
    private String[] paramName;
    private String[] paramDesc;
    private String[] returnName;
    private String[] returnDesc;
    private static final String undocumented = "???";
    private static final Class<?>[] handlerParams = new Class[]{Request.class};

    private void init(String name, String paramTypes, String returnTypes) {
        int i;
        this.name = name;
        this.paramTypes = paramTypes;
        this.returnTypes = returnTypes;
        this.desc = undocumented;
        this.paramName = new String[this.paramTypes.length()];
        this.paramDesc = new String[this.paramTypes.length()];
        for (i = 0; i < this.paramTypes.length(); ++i) {
            this.paramName[i] = undocumented;
            this.paramDesc[i] = undocumented;
        }
        this.returnName = new String[this.returnTypes.length()];
        this.returnDesc = new String[this.returnTypes.length()];
        for (i = 0; i < this.returnTypes.length(); ++i) {
            this.returnName[i] = undocumented;
            this.returnDesc[i] = undocumented;
        }
    }

    public Method(String name, String paramTypes, String returnTypes, Object handler, String handlerMethod) {
        this.handler = null;
        this.object = handler;
        try {
            this.method = this.object.getClass().getMethod(handlerMethod, handlerParams);
        }
        catch (Exception e) {
            throw new MethodCreateException("Method lookup failed", e);
        }
        this.init(name, paramTypes, returnTypes);
    }

    public Method(String name, String paramTypes, String returnTypes, MethodHandler handler) {
        this.handler = handler;
        this.object = null;
        this.method = null;
        if (this.handler == null) {
            throw new MethodCreateException("Handler is null");
        }
        this.init(name, paramTypes, returnTypes);
    }

    String name() {
        return this.name;
    }

    String paramTypes() {
        return this.paramTypes;
    }

    String returnTypes() {
        return this.returnTypes;
    }

    public Method methodDesc(String desc) {
        this.desc = desc;
        return this;
    }

    String methodDesc() {
        return this.desc;
    }

    public Method paramDesc(int index, String name, String desc) {
        this.paramName[index] = name;
        this.paramDesc[index] = desc;
        return this;
    }

    String paramName(int index) {
        return this.paramName[index];
    }

    String paramDesc(int index) {
        return this.paramDesc[index];
    }

    public Method returnDesc(int index, String name, String desc) {
        this.returnName[index] = name;
        this.returnDesc[index] = desc;
        return this;
    }

    String returnName(int index) {
        return this.returnName[index];
    }

    String returnDesc(int index) {
        return this.returnDesc[index];
    }

    boolean checkParameters(Request req) {
        return req.parameters().satisfies(this.paramTypes);
    }

    boolean checkReturnValues(Request req) {
        return req.returnValues().satisfies(this.returnTypes);
    }

    void invoke(Request req) {
        try {
            if (this.handler != null) {
                this.handler.invoke(req);
            } else {
                Object[] args = new Object[]{req};
                this.method.invoke(this.object, args);
            }
        }
        catch (Exception e) {
            req.setError(111, e.toString());
        }
    }

    public String toString() {
        return "method " + this.name + "(" + this.paramTypes + ")" + (String)(this.returnTypes.length() > 0 ? ": " + this.returnTypes : "");
    }
}

