/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.concurrent.ThreadFactoryFactory;
import com.yahoo.jrt.Connection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class Connector {
    private final ExecutorService executor = new ThreadPoolExecutor(1, 64, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), ThreadFactoryFactory.getDaemonThreadFactory((String)"jrt.connector"));

    Connector() {
    }

    private void connect(Connection conn) {
        conn.transportThread().addConnection(conn.connect());
    }

    public void connectLater(Connection conn) {
        try {
            this.executor.execute(() -> this.connect(conn));
        }
        catch (RejectedExecutionException e) {
            conn.transportThread().addConnection(conn);
        }
    }

    public Connector shutdown() {
        this.executor.shutdown();
        return this;
    }

    public void join() {
        while (true) {
            try {
                while (!this.executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

