/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.Buffer;
import com.yahoo.jrt.CryptoSocket;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.SecureRandom;
import java.util.ArrayDeque;
import java.util.Queue;

public class XorCryptoSocket
implements CryptoSocket {
    private static final int CHUNK_SIZE = 4096;
    private Queue<OP> opList = new ArrayDeque<OP>();
    private byte myKey = XorCryptoSocket.genKey();
    private byte peerKey;
    private Buffer input = new Buffer(4096);
    private Buffer output = new Buffer(4096);
    private SocketChannel channel;

    private static byte genKey() {
        return (byte)new SecureRandom().nextInt(256);
    }

    private CryptoSocket.HandshakeResult readKey() throws IOException {
        int res = this.channel.read(this.input.getWritable(1));
        if (res > 0) {
            this.peerKey = this.input.getReadable().get();
            return CryptoSocket.HandshakeResult.DONE;
        }
        if (res == 0) {
            return CryptoSocket.HandshakeResult.NEED_READ;
        }
        throw new IOException("EOF during handshake");
    }

    private CryptoSocket.HandshakeResult writeKey() throws IOException {
        if (this.output.bytes() == 0) {
            this.output.getWritable(1).put(this.myKey);
        }
        if (this.channel.write(this.output.getReadable()) == 0) {
            return CryptoSocket.HandshakeResult.NEED_WRITE;
        }
        return CryptoSocket.HandshakeResult.DONE;
    }

    private CryptoSocket.HandshakeResult perform(OP op) throws IOException {
        switch (op) {
            case READ_KEY: {
                return this.readKey();
            }
            case WRITE_KEY: {
                return this.writeKey();
            }
        }
        throw new IOException("invalid handshake operation");
    }

    public XorCryptoSocket(SocketChannel channel, boolean isServer) {
        this.channel = channel;
        if (isServer) {
            this.opList.add(OP.READ_KEY);
            this.opList.add(OP.WRITE_KEY);
        } else {
            this.opList.add(OP.WRITE_KEY);
            this.opList.add(OP.READ_KEY);
        }
    }

    @Override
    public SocketChannel channel() {
        return this.channel;
    }

    @Override
    public CryptoSocket.HandshakeResult handshake() throws IOException {
        while (!this.opList.isEmpty()) {
            CryptoSocket.HandshakeResult partialResult = this.perform(this.opList.element());
            if (partialResult != CryptoSocket.HandshakeResult.DONE) {
                return partialResult;
            }
            this.opList.remove();
        }
        return CryptoSocket.HandshakeResult.DONE;
    }

    @Override
    public int getMinimumReadBufferSize() {
        return 1;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (this.input.bytes() == 0 && this.channel.read(this.input.getWritable(4096)) == -1) {
            return -1;
        }
        return this.drain(dst);
    }

    @Override
    public int drain(ByteBuffer dst) throws IOException {
        int cnt = 0;
        ByteBuffer src = this.input.getReadable();
        while (src.hasRemaining() && dst.hasRemaining()) {
            dst.put((byte)(src.get() ^ this.myKey));
            ++cnt;
        }
        return cnt;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int cnt = 0;
        if (this.flush() == CryptoSocket.FlushResult.DONE) {
            ByteBuffer dst = this.output.getWritable(4096);
            while (src.hasRemaining() && dst.hasRemaining()) {
                dst.put((byte)(src.get() ^ this.peerKey));
                ++cnt;
            }
        }
        return cnt;
    }

    @Override
    public CryptoSocket.FlushResult flush() throws IOException {
        ByteBuffer src = this.output.getReadable();
        this.channel.write(src);
        if (src.hasRemaining()) {
            return CryptoSocket.FlushResult.NEED_WRITE;
        }
        return CryptoSocket.FlushResult.DONE;
    }

    static enum OP {
        READ_KEY,
        WRITE_KEY;

    }
}

