/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.Connection;
import com.yahoo.jrt.ListenFailedException;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Transport;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Acceptor {
    private static final Logger log = Logger.getLogger(Acceptor.class.getName());
    private final Thread thread = new Thread((Runnable)new Run(), "<acceptor>");
    private final CountDownLatch shutdownGate = new CountDownLatch(1);
    private final Transport parent;
    private final Supervisor owner;
    private final ServerSocketChannel serverChannel;

    Acceptor(Transport parent, Supervisor owner, Spec spec) throws ListenFailedException {
        this.parent = parent;
        this.owner = owner;
        if (spec.malformed()) {
            throw new ListenFailedException("Malformed spec '" + spec + "'");
        }
        this.serverChannel = Acceptor.createServerSocketChannel(spec);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private static ServerSocketChannel createServerSocketChannel(Spec spec) throws ListenFailedException {
        ServerSocketChannel serverChannel = null;
        try {
            serverChannel = ServerSocketChannel.open();
            serverChannel.configureBlocking(true);
            if (spec.port() != 0) {
                serverChannel.socket().setReuseAddress(true);
            }
            serverChannel.socket().bind(spec.address(), 500);
        }
        catch (Exception e) {
            if (serverChannel != null) {
                try {
                    serverChannel.socket().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new ListenFailedException("Failed to listen to " + spec, e);
        }
        return serverChannel;
    }

    public int port() {
        if (!this.serverChannel.isOpen()) {
            return -1;
        }
        return this.serverChannel.socket().getLocalPort();
    }

    public Spec spec() {
        if (!this.serverChannel.isOpen()) {
            return null;
        }
        return new Spec(this.serverChannel.socket().getInetAddress().getHostName(), this.serverChannel.socket().getLocalPort());
    }

    private void run() {
        while (this.serverChannel.isOpen()) {
            try {
                this.parent.addConnection(new Connection(this.parent, this.owner, this.serverChannel.accept()));
                this.parent.sync();
            }
            catch (ClosedChannelException closedChannelException) {
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Error accepting connection", e);
            }
        }
        while (true) {
            try {
                this.shutdownGate.await();
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Acceptor shutdown() {
        try {
            this.serverChannel.socket().close();
        }
        catch (Exception e1) {
            log.log(Level.WARNING, "Error closing server socket", e1);
            Thread.yield();
            try {
                this.serverChannel.socket().close();
            }
            catch (Exception e2) {
                log.log(Level.WARNING, "Error closing server socket", e2);
                Thread.yield();
                try {
                    this.serverChannel.socket().close();
                }
                catch (Exception e3) {
                    log.log(Level.WARNING, "Error closing server socket", e3);
                    throw new Error("Error closing server socket 3 times", e3);
                }
            }
        }
        finally {
            this.shutdownGate.countDown();
        }
        return this;
    }

    public void join() {
        while (true) {
            try {
                this.thread.join();
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private class Run
    implements Runnable {
        private Run() {
        }

        @Override
        public void run() {
            try {
                Acceptor.this.run();
            }
            catch (Throwable problem) {
                Acceptor.this.parent.handleFailure(problem, Acceptor.this);
            }
        }
    }
}

