/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.Connection;
import com.yahoo.jrt.EndOfQueueException;
import com.yahoo.jrt.ThreadQueue;
import com.yahoo.jrt.Transport;

class Connector {
    private Thread thread = new Thread((Runnable)new Run(), "<connector>");
    private Transport parent;
    private ThreadQueue connectQueue = new ThreadQueue();
    private boolean done = false;
    private boolean exit = false;

    public Connector(Transport parent) {
        this.parent = parent;
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void connectLater(Connection c) {
        if (!this.connectQueue.enqueue(c)) {
            this.parent.addConnection(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        try {
            while (true) {
                Connection conn = (Connection)this.connectQueue.dequeue();
                this.parent.addConnection(conn.connect());
            }
        }
        catch (EndOfQueueException endOfQueueException) {
            Connector connector = this;
            synchronized (connector) {
                this.done = true;
                this.notifyAll();
                while (!this.exit) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            return;
        }
    }

    public Connector shutdown() {
        this.connectQueue.close();
        return this;
    }

    public synchronized void waitDone() {
        while (!this.done) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized Connector exit() {
        this.exit = true;
        this.notifyAll();
        return this;
    }

    public void join() {
        while (true) {
            try {
                this.thread.join();
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private class Run
    implements Runnable {
        private Run() {
        }

        @Override
        public void run() {
            try {
                Connector.this.run();
            }
            catch (Throwable problem) {
                Connector.this.parent.handleFailure(problem, Connector.this);
            }
        }
    }
}

