/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.secret.aws;

import ai.vespa.secret.aws.AwsRolePath;
import ai.vespa.secret.model.ExternalId;
import java.util.Objects;
import java.util.Optional;

public record AssumedRoleInfo(AwsRolePath role, Optional<ExternalId> externalId) {
    public AssumedRoleInfo {
        Objects.requireNonNull(role, "role cannot be null");
        Objects.requireNonNull(externalId, "externalId cannot be null");
    }

    public static AssumedRoleInfo of(AwsRolePath role) {
        return new AssumedRoleInfo(role, Optional.empty());
    }

    public static AssumedRoleInfo of(AwsRolePath role, ExternalId externalId) {
        return new AssumedRoleInfo(role, Optional.ofNullable(externalId));
    }
}

