/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.secret.aws;

import ai.vespa.secret.aws.AwsPath;
import com.yahoo.vespa.athenz.api.AwsRole;
import java.util.Objects;

public record AwsRolePath(AwsPath path, AwsRole role) {
    public AwsRolePath {
        Objects.requireNonNull(path, "path cannot be null");
        Objects.requireNonNull(role, "role cannot be null");
    }

    public static AwsRolePath fromStrings(String path, String roleName) {
        if (roleName == null || roleName.isEmpty()) {
            throw new IllegalArgumentException("roleName cannot be null or empty");
        }
        return new AwsRolePath(AwsPath.fromAwsPathString(path), new AwsRole(roleName));
    }

    public static AwsRolePath atRoot(String roleName) {
        return new AwsRolePath(AwsPath.of(new String[0]), new AwsRole(roleName));
    }

    public String athenzResourceName() {
        return this.fullName().substring(1);
    }

    public AwsRole athenzAwsRole() {
        return new AwsRole(this.athenzResourceName());
    }

    @Override
    public String toString() {
        return "AwsRolePath{" + this.path + ", " + this.role.name() + "}";
    }

    private String fullName() {
        return "%s%s".formatted(this.path.value(), this.role.name());
    }
}

