/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.secret.aws.testutil;

import ai.vespa.secret.aws.AssumedRoleInfo;
import ai.vespa.secret.aws.AwsRolePath;
import ai.vespa.secret.aws.testutil.AsmSecretTesterBase;
import ai.vespa.secret.model.Key;
import ai.vespa.secret.model.SecretVersionState;
import java.util.List;
import java.util.function.Function;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;
import software.amazon.awssdk.services.secretsmanager.model.ResourceNotFoundException;

public class AsmSecretReaderTester
extends AsmSecretTesterBase {
    public AsmSecretReaderTester(Function<Key, String> awsSecretId) {
        super(awsSecretId);
    }

    public void put(Key key, AsmSecretTesterBase.SecretVersion ... versions) {
        this.secrets.put((String)this.awsSecretIdMapper.apply(key), List.of(versions));
    }

    public MockSecretsReader newClient(AssumedRoleInfo assumedRoleInfo) {
        return new MockSecretsReader(assumedRoleInfo.role());
    }

    public class MockSecretsReader
    extends AsmSecretTesterBase.MockSecretsManagerClient {
        MockSecretsReader(AwsRolePath awsRole) {
            super(AsmSecretReaderTester.this, awsRole);
        }

        public GetSecretValueResponse getSecretValue(GetSecretValueRequest request) {
            String id = request.secretId();
            String reqVersion = request.versionId();
            List versions = (List)AsmSecretReaderTester.this.secrets.get(id);
            if (versions == null) {
                throw (ResourceNotFoundException)ResourceNotFoundException.builder().message("Secret not found").build();
            }
            AsmSecretTesterBase.SecretVersion secret = this.findSecret(versions, reqVersion);
            return (GetSecretValueResponse)GetSecretValueResponse.builder().name(request.secretId()).secretString(secret.value()).versionId(secret.version()).versionStages(List.of(this.toAwsStage(secret.state()))).build();
        }

        AsmSecretTesterBase.SecretVersion findSecret(List<AsmSecretTesterBase.SecretVersion> versions, String reqVersion) {
            return versions.stream().filter(reqVersion == null ? v -> v.state() == SecretVersionState.CURRENT : v -> v.version().equals(reqVersion)).findFirst().orElseThrow(() -> (ResourceNotFoundException)ResourceNotFoundException.builder().message("Version not found: " + reqVersion).build());
        }

        public String serviceName() {
            return MockSecretsReader.class.getSimpleName();
        }
    }
}

