/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.secret.aws.testutil;

import ai.vespa.secret.model.Key;
import ai.vespa.secret.model.SecretVersionState;
import com.yahoo.vespa.athenz.api.AwsRole;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.model.InternalServiceErrorException;
import software.amazon.awssdk.services.secretsmanager.model.InvalidNextTokenException;
import software.amazon.awssdk.services.secretsmanager.model.InvalidParameterException;
import software.amazon.awssdk.services.secretsmanager.model.ListSecretVersionIdsRequest;
import software.amazon.awssdk.services.secretsmanager.model.ListSecretVersionIdsResponse;
import software.amazon.awssdk.services.secretsmanager.model.ResourceNotFoundException;
import software.amazon.awssdk.services.secretsmanager.model.SecretVersionsListEntry;
import software.amazon.awssdk.services.secretsmanager.model.SecretsManagerException;

public class AsmSecretTesterBase {
    protected final Map<String, List<SecretVersion>> secrets = new HashMap<String, List<SecretVersion>>();
    protected final List<MockSecretsManagerClient> clients = new ArrayList<MockSecretsManagerClient>();
    protected final Function<Key, String> awsSecretIdMapper;

    public AsmSecretTesterBase(Function<Key, String> awsSecretId) {
        this.awsSecretIdMapper = awsSecretId;
    }

    public void reset() {
        this.secrets.clear();
        this.clients.clear();
    }

    public List<MockSecretsManagerClient> clients() {
        return List.copyOf(this.clients);
    }

    public abstract class MockSecretsManagerClient
    implements SecretsManagerClient {
        public final AwsRole awsRole;
        public boolean isClosed = false;

        protected MockSecretsManagerClient(AwsRole awsRole) {
            this.awsRole = awsRole;
            AsmSecretTesterBase.this.clients.add(this);
        }

        public ListSecretVersionIdsResponse listSecretVersionIds(ListSecretVersionIdsRequest request) throws InvalidNextTokenException, ResourceNotFoundException, InternalServiceErrorException, InvalidParameterException, AwsServiceException, SdkClientException, SecretsManagerException {
            return (ListSecretVersionIdsResponse)ListSecretVersionIdsResponse.builder().name(request.secretId()).versions(AsmSecretTesterBase.this.secrets.getOrDefault(request.secretId(), List.of()).stream().map(version -> (SecretVersionsListEntry)SecretVersionsListEntry.builder().versionId(version.version()).versionStages(List.of(this.toAwsStage(version.state()))).build()).toList()).build();
        }

        public void close() {
            this.isClosed = true;
        }

        protected String toAwsStage(SecretVersionState state) {
            return switch (state) {
                case SecretVersionState.CURRENT -> "AWSCURRENT";
                case SecretVersionState.PENDING -> "AWSPENDING";
                case SecretVersionState.PREVIOUS -> "AWSPREVIOUS";
                default -> throw new IllegalArgumentException("Unknown state: " + state);
            };
        }
    }

    public record SecretVersion(String version, SecretVersionState state, String value) {
    }
}

