/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.secret.aws;

import ai.vespa.secret.Secret;
import ai.vespa.secret.Secrets;
import ai.vespa.secret.aws.AsmSecretReader;
import ai.vespa.secret.config.SecretsConfig;
import ai.vespa.secret.internal.TypedSecretStore;
import ai.vespa.secret.model.Key;
import ai.vespa.secret.model.SecretName;
import ai.vespa.secret.model.VaultName;
import javax.inject.Inject;

public class SecretsImpl
implements Secrets {
    private final SecretsConfig secretsConfig;
    private final TypedSecretStore secretStore;

    @Inject
    public SecretsImpl(SecretsConfig config, AsmSecretReader asmSecretReader) {
        this.secretStore = asmSecretReader;
        this.secretsConfig = config;
    }

    SecretsImpl(SecretsConfig secretsConfig, TypedSecretStore secretStore) {
        this.secretsConfig = secretsConfig;
        this.secretStore = secretStore;
    }

    public Secret get(String key) {
        SecretName secretName;
        SecretsConfig.Secret secretConfig = this.secretsConfig.secret(key);
        if (secretConfig == null) {
            throw new IllegalArgumentException("Secret with key '" + key + "' not found in secrets config");
        }
        VaultName vaultName = VaultName.of((String)secretConfig.vault());
        ai.vespa.secret.model.Secret secret = this.secretStore.getSecret(new Key(vaultName, secretName = SecretName.of((String)secretConfig.name())));
        if (secret == null) {
            throw new IllegalArgumentException("Secret with key '" + key + "' not found in secret store");
        }
        return () -> ((ai.vespa.secret.model.Secret)secret).secretAsString();
    }
}

