/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.cloud.aws;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReference;

public class VespaAwsCredentialsProvider
implements AWSCredentialsProvider {
    private static final String DEFAULT_CREDENTIALS_PATH = "/opt/vespa/var/vespa/aws/credentials.json";
    private final AtomicReference<AWSCredentials> credentials = new AtomicReference();
    private final Path credentialsPath = Path.of("/opt/vespa/var/vespa/aws/credentials.json", new String[0]);

    public VespaAwsCredentialsProvider() {
        this.refresh();
    }

    public AWSCredentials getCredentials() {
        return this.credentials.get();
    }

    public void refresh() {
        try {
            this.credentials.set((AWSCredentials)this.readCredentials());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get credentials. Please ensure cluster is configured as exclusive. See: https://cloud.vespa.ai/en/reference/services#nodes");
        }
    }

    private AWSSessionCredentials readCredentials() {
        try {
            Slime slime = SlimeUtils.jsonToSlime((byte[])Files.readAllBytes(this.credentialsPath));
            Cursor cursor = slime.get();
            String accessKey = cursor.field("awsAccessKey").asString();
            String secretKey = cursor.field("awsSecretKey").asString();
            String sessionToken = cursor.field("sessionToken").asString();
            return new BasicSessionCredentials(accessKey, secretKey, sessionToken);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

