/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.cloud.aws;

import com.google.inject.Inject;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.LoggingRequestHandler;
import com.yahoo.io.IOUtils;
import com.yahoo.jdisc.cloud.aws.AwsParameterStore;
import com.yahoo.jdisc.cloud.aws.VespaAwsCredentialsProvider;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.restapi.ErrorResponse;
import com.yahoo.restapi.SlimeJsonResponse;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AwsParameterStoreValidationHandler
extends LoggingRequestHandler {
    private static final Logger log = Logger.getLogger(AwsParameterStoreValidationHandler.class.getName());
    private final VespaAwsCredentialsProvider credentialsProvider;

    @Inject
    public AwsParameterStoreValidationHandler(LoggingRequestHandler.Context ctx) {
        this(ctx, new VespaAwsCredentialsProvider());
    }

    public AwsParameterStoreValidationHandler(LoggingRequestHandler.Context ctx, VespaAwsCredentialsProvider credentialsProvider) {
        super(ctx);
        this.credentialsProvider = credentialsProvider;
    }

    public HttpResponse handle(HttpRequest request) {
        try {
            if (request.getMethod() == HttpRequest.Method.POST) {
                return this.handlePOST(request);
            }
            return ErrorResponse.methodNotAllowed((String)("Method '" + request.getMethod() + "' is not supported"));
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, "Unexpected error handling '" + request.getUri() + "'", e);
            return ErrorResponse.internalServerError((String)Exceptions.toMessageString((Throwable)e));
        }
    }

    private HttpResponse handlePOST(HttpRequest request) {
        Slime json = this.toSlime(request.getData());
        AwsSettings settings = AwsSettings.fromSlime(json);
        Slime response = new Slime();
        Cursor root = response.setObject();
        settings.toSlime(root.setObject("settings"));
        try {
            String arn = "arn:aws:iam::" + settings.awsId + ":role/" + settings.role;
            AwsParameterStore store = new AwsParameterStore(this.credentialsProvider, arn, settings.externalId);
            store.getSecret("vespa-secret");
            root.setString("status", "ok");
        }
        catch (RuntimeException e) {
            root.setString("status", "error");
            Cursor error = root.setArray("errors").addObject();
            error.setString("type", e.getClass().getSimpleName());
            error.setString("message", Exceptions.toMessageString((Throwable)e));
        }
        return new SlimeJsonResponse(response);
    }

    private Slime toSlime(InputStream jsonStream) {
        try {
            byte[] jsonBytes = IOUtils.readBytes((InputStream)jsonStream, (int)1000000);
            return SlimeUtils.jsonToSlime((byte[])jsonBytes);
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    private static class AwsSettings {
        String name;
        String role;
        String awsId;
        String externalId;

        AwsSettings(String name, String role, String awsId, String externalId) {
            this.name = name;
            this.role = role;
            this.awsId = awsId;
            this.externalId = externalId;
        }

        static AwsSettings fromSlime(Slime slime) {
            Cursor json = slime.get();
            return new AwsSettings(json.field("name").asString(), json.field("role").asString(), json.field("awsId").asString(), json.field("externalId").asString());
        }

        void toSlime(Cursor slime) {
            slime.setString("name", this.name);
            slime.setString("role", this.role);
            slime.setString("awsId", this.awsId);
            slime.setString("externalId", "*****");
        }
    }
}

