/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.MapDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.MapFieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.TypeContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import java.util.Objects;

public final class GetValueExpression
extends Expression {
    private final String mapKey;

    public GetValueExpression(String mapKey) {
        this.mapKey = mapKey;
    }

    public String getMapKey() {
        return this.mapKey;
    }

    @Override
    public DataType setInputType(DataType inputType, TypeContext context) {
        super.setInputType(inputType, context);
        if (inputType == null) {
            return null;
        }
        if (!(inputType instanceof MapDataType)) {
            throw new VerificationException(this, "Expected a Map input, got " + inputType.getName());
        }
        MapDataType mapInputType = (MapDataType)inputType;
        return mapInputType.getValueType();
    }

    @Override
    public DataType setOutputType(DataType outputType, TypeContext context) {
        super.setOutputType(outputType, context);
        return this.getInputType(context);
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        MapFieldValue input = (MapFieldValue)context.getCurrentValue();
        FieldValue key = input.getDataType().getKeyType().getPrimitiveType().createFieldValue((Object)this.mapKey);
        context.setCurrentValue(input.get((Object)key));
    }

    public String toString() {
        return "get_value " + this.mapKey;
    }

    public boolean equals(Object o) {
        if (!(o instanceof GetValueExpression)) {
            return false;
        }
        GetValueExpression other = (GetValueExpression)((Object)o);
        return this.mapKey.equals(other.mapKey);
    }

    public int hashCode() {
        return Objects.hash(((Object)((Object)this)).getClass(), this.mapKey);
    }
}

