/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.document.datatypes.PredicateFieldValue;
import com.yahoo.document.predicate.Predicate;
import com.yahoo.search.predicate.optimization.AndOrSimplifier;
import com.yahoo.search.predicate.optimization.BooleanSimplifier;
import com.yahoo.search.predicate.optimization.ComplexNodeTransformer;
import com.yahoo.search.predicate.optimization.NotNodeReorderer;
import com.yahoo.search.predicate.optimization.PredicateOptions;
import com.yahoo.search.predicate.optimization.PredicateProcessor;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.TypeContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;

public final class OptimizePredicateExpression
extends Expression {
    private final PredicateProcessor optimizer;

    public OptimizePredicateExpression() {
        this(new PredicateOptimizer());
    }

    OptimizePredicateExpression(PredicateProcessor optimizer) {
        this.optimizer = optimizer;
    }

    @Override
    public boolean isMutating() {
        return false;
    }

    @Override
    public DataType setInputType(DataType inputType, TypeContext context) {
        DataType input = super.setInputType(inputType, (DataType)DataType.PREDICATE, context);
        this.checkVariable(context, "arity", (DataType)DataType.INT, true);
        this.checkVariable(context, "lower_bound", (DataType)DataType.LONG, false);
        this.checkVariable(context, "upper_bound", (DataType)DataType.LONG, false);
        return input;
    }

    @Override
    public DataType setOutputType(DataType outputType, TypeContext context) {
        return super.setOutputType((DataType)DataType.PREDICATE, outputType, null, context);
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        PredicateFieldValue predicate = ((PredicateFieldValue)context.getCurrentValue()).clone();
        IntegerFieldValue arity = (IntegerFieldValue)context.getVariable("arity");
        LongFieldValue lower_bound = (LongFieldValue)context.getVariable("lower_bound");
        LongFieldValue upper_bound = (LongFieldValue)context.getVariable("upper_bound");
        Long lower = lower_bound != null ? Long.valueOf(lower_bound.getLong()) : null;
        Long upper = upper_bound != null ? Long.valueOf(upper_bound.getLong()) : null;
        PredicateOptions options = new PredicateOptions(arity.getInteger(), lower, upper);
        predicate.setPredicate(this.optimizer.process(predicate.getPredicate(), options));
        context.setCurrentValue((FieldValue)predicate);
    }

    private void checkVariable(TypeContext context, String var, DataType type, boolean required) {
        DataType input = context.getVariableType(var);
        if (input == null) {
            if (required) {
                throw new VerificationException(this, "Variable '" + var + "' must be set");
            }
        } else if (input != type) {
            throw new VerificationException(this, "Variable '" + var + "' must have type " + type.getName());
        }
    }

    public String toString() {
        return "optimize_predicate";
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof OptimizePredicateExpression;
    }

    private static class PredicateOptimizer
    implements PredicateProcessor {
        private final ComplexNodeTransformer complexNodeTransformer = new ComplexNodeTransformer();
        private final BooleanSimplifier booleanSimplifier = new BooleanSimplifier();
        private final AndOrSimplifier andOrSimplifier = new AndOrSimplifier();
        private final NotNodeReorderer notNodeReorderer = new NotNodeReorderer();

        private PredicateOptimizer() {
        }

        public Predicate process(Predicate predicate, PredicateOptions options) {
            Predicate processedPredicate = this.complexNodeTransformer.process(predicate, options);
            processedPredicate = this.booleanSimplifier.process(processedPredicate, options);
            processedPredicate = this.andOrSimplifier.process(processedPredicate, options);
            return this.notNodeReorderer.process(processedPredicate, options);
        }
    }
}

