/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.FieldTypes;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class TypeContext {
    private final Map<String, DataType> variableTypes = new HashMap<String, DataType>();
    private final FieldTypes fieldTypes;

    public TypeContext(FieldTypes fieldTypes) {
        this.fieldTypes = Objects.requireNonNull(fieldTypes);
    }

    public TypeContext resolve(Expression expression) {
        if (expression != null) {
            expression.resolve(this);
        }
        return this;
    }

    public DataType getFieldType(String fieldName, Expression expression) {
        return this.fieldTypes.getFieldType(fieldName, expression);
    }

    public DataType getVariableType(String name) {
        return this.variableTypes.get(name);
    }

    public TypeContext setVariableType(String name, DataType value) {
        this.variableTypes.put(name, value);
        return this;
    }

    public TypeContext clear() {
        this.variableTypes.clear();
        return this;
    }
}

