/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.language.Linguistics;
import com.yahoo.language.process.Embedder;
import com.yahoo.language.process.FieldGenerator;
import com.yahoo.language.simple.SimpleLinguistics;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.ScriptParser;
import com.yahoo.vespa.indexinglanguage.ScriptParserContext;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.ExpressionList;
import com.yahoo.vespa.indexinglanguage.expressions.InputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.TypeContext;
import com.yahoo.vespa.indexinglanguage.parser.IndexingInput;
import com.yahoo.vespa.indexinglanguage.parser.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class StatementExpression
extends ExpressionList<Expression> {
    private final List<String> inputFields = List.copyOf(InputExpression.InputFieldNameExtractor.runOn(this));

    public StatementExpression(Expression ... list) {
        this((Iterable<Expression>)Arrays.asList(list));
    }

    public StatementExpression(Iterable<Expression> list) {
        this(StatementExpression.filterList(list), null);
    }

    private StatementExpression(Iterable<Expression> list, Object unused) {
        super(list);
    }

    @Override
    public boolean isMutating() {
        return this.expressions().stream().anyMatch(expression -> expression.isMutating());
    }

    public List<String> getInputFields() {
        return this.inputFields;
    }

    @Override
    public StatementExpression convertChildren(ExpressionConverter converter) {
        return new StatementExpression((Iterable<Expression>)this.asList().stream().map(converter::convert).filter(Objects::nonNull).toList());
    }

    @Override
    public DataType setInputType(DataType input, TypeContext context) {
        super.setInputType(input, context);
        this.resolveBackwards(context);
        return this.resolveForwards(context);
    }

    @Override
    public DataType setOutputType(DataType output, TypeContext context) {
        super.setOutputType(output, context);
        this.resolveForwards(context);
        return this.resolveBackwards(context);
    }

    private DataType resolveForwards(TypeContext context) {
        DataType type = this.getInputType(context);
        for (Expression expression : this.expressions()) {
            type = expression.setInputType(type, context);
            if ((type = expression.assignOutputType(type)) != null) continue;
            break;
        }
        return type;
    }

    private DataType resolveBackwards(TypeContext context) {
        int i = this.expressions().size();
        DataType type = this.getOutputType(context);
        if (type == null) {
            type = ((Expression)((Object)this.expressions().get(--i))).getInputType(context);
        }
        while (--i >= 0) {
            type = ((Expression)((Object)this.expressions().get(i))).setOutputType(type, context);
            type = ((Expression)((Object)this.expressions().get(i))).assignInputType(type);
        }
        return type;
    }

    @Override
    protected void doResolve(TypeContext context) {
        if (this.expressions().isEmpty()) {
            return;
        }
        DataType outputType = this.resolveForwards(context);
        this.assignOutputType(outputType);
        this.resolveBackwards(context);
        for (Expression expression : this.expressions()) {
            context.resolve(expression);
        }
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        for (Expression expression : this) {
            context.execute(expression);
        }
    }

    public String toString() {
        return this.asList().stream().map(Object::toString).collect(Collectors.joining(" | "));
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && obj instanceof StatementExpression;
    }

    public static StatementExpression fromString(String expression) throws ParseException {
        return StatementExpression.fromString(expression, (Linguistics)new SimpleLinguistics(), Embedder.throwsOnUse.asMap());
    }

    public static StatementExpression fromString(String expression, Linguistics linguistics, Map<String, Embedder> embedders) throws ParseException {
        return StatementExpression.newInstance(new ScriptParserContext(linguistics, embedders, Map.of()).setInputStream(new IndexingInput(expression)));
    }

    public static StatementExpression fromString(String expression, Linguistics linguistics, Map<String, Embedder> embedders, Map<String, FieldGenerator> generators) throws ParseException {
        return StatementExpression.newInstance(new ScriptParserContext(linguistics, embedders, generators).setInputStream(new IndexingInput(expression)));
    }

    public static StatementExpression newInstance(ScriptParserContext config) throws ParseException {
        return ScriptParser.parseStatement(config);
    }

    private static List<Expression> filterList(Iterable<Expression> list) {
        ArrayList<Expression> filtered = new ArrayList<Expression>();
        for (Expression expression : list) {
            if (expression instanceof StatementExpression) {
                StatementExpression statement = (StatementExpression)expression;
                filtered.addAll(StatementExpression.filterList(statement));
                continue;
            }
            if (expression == null) continue;
            filtered.add(expression);
        }
        return filtered;
    }
}

