/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.linguistics;

import com.yahoo.language.Language;
import com.yahoo.language.process.LinguisticsParameters;
import com.yahoo.language.process.StemMode;
import com.yahoo.vespa.configdefinition.IlscriptsConfig;
import java.util.Objects;

public class AnnotatorConfig
implements Cloneable {
    private Language language;
    private StemMode stemMode;
    private boolean removeAccents;
    private boolean lowercase;
    private int maxTermOccurrences;
    private int maxTokenLength;
    private int maxTokenizeLength;
    public static final int DEFAULT_MAX_TERM_OCCURRENCES;
    private static final int DEFAULT_MAX_TOKEN_LENGTH;
    private static final int DEFAULT_MAX_TOKENIZE_LENGTH;

    public AnnotatorConfig() {
        this.language = Language.ENGLISH;
        this.stemMode = StemMode.NONE;
        this.removeAccents = false;
        this.lowercase = true;
        this.maxTermOccurrences = DEFAULT_MAX_TERM_OCCURRENCES;
        this.maxTokenLength = DEFAULT_MAX_TOKEN_LENGTH;
        this.maxTokenizeLength = DEFAULT_MAX_TOKENIZE_LENGTH;
    }

    public AnnotatorConfig(AnnotatorConfig other) {
        this.language = other.language;
        this.stemMode = other.stemMode;
        this.removeAccents = other.removeAccents;
        this.lowercase = other.lowercase;
        this.maxTermOccurrences = other.maxTermOccurrences;
        this.maxTokenLength = other.maxTokenLength;
        this.maxTokenizeLength = other.maxTokenizeLength;
    }

    public Language getLanguage() {
        return this.language;
    }

    public AnnotatorConfig setLanguage(Language language) {
        this.language = language;
        return this;
    }

    public StemMode getStemMode() {
        return this.stemMode;
    }

    public AnnotatorConfig setStemMode(StemMode stemMode) {
        this.stemMode = stemMode;
        return this;
    }

    public AnnotatorConfig setStemMode(String name) {
        this.stemMode = StemMode.valueOf((String)name);
        return this;
    }

    public boolean getRemoveAccents() {
        return this.removeAccents;
    }

    public AnnotatorConfig setRemoveAccents(boolean removeAccents) {
        this.removeAccents = removeAccents;
        return this;
    }

    public boolean getLowercase() {
        return this.lowercase;
    }

    public AnnotatorConfig setLowercase(boolean lowercase) {
        this.lowercase = lowercase;
        return this;
    }

    public int getMaxTermOccurrences() {
        return this.maxTermOccurrences;
    }

    public AnnotatorConfig setMaxTermOccurrences(int maxTermCount) {
        this.maxTermOccurrences = maxTermCount;
        return this;
    }

    public AnnotatorConfig setMaxTokenLength(int maxTokenLength) {
        this.maxTokenLength = maxTokenLength;
        return this;
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    public static int getDefaultMaxTokenLength() {
        return DEFAULT_MAX_TOKEN_LENGTH;
    }

    public AnnotatorConfig setMaxTokenizeLength(int maxTokenizeLength) {
        this.maxTokenizeLength = maxTokenizeLength;
        return this;
    }

    public int getMaxTokenizeLength() {
        return this.maxTokenizeLength;
    }

    public boolean hasNonDefaultMaxTokenLength() {
        return this.maxTokenLength != DEFAULT_MAX_TOKEN_LENGTH;
    }

    public boolean hasNonDefaultMaxTokenizeLength() {
        return this.maxTokenizeLength != DEFAULT_MAX_TOKENIZE_LENGTH;
    }

    public boolean hasNonDefaultMaxTermOccurrences() {
        return this.maxTermOccurrences != DEFAULT_MAX_TERM_OCCURRENCES;
    }

    public LinguisticsParameters asLinguisticsParameters() {
        return new LinguisticsParameters(this.language, this.stemMode, this.removeAccents, this.lowercase);
    }

    public boolean equals(Object o) {
        if (!(o instanceof AnnotatorConfig)) {
            return false;
        }
        AnnotatorConfig other = (AnnotatorConfig)o;
        if (!this.language.equals((Object)other.language)) {
            return false;
        }
        if (!this.stemMode.equals((Object)other.stemMode)) {
            return false;
        }
        if (this.removeAccents != other.removeAccents) {
            return false;
        }
        if (this.lowercase != other.lowercase) {
            return false;
        }
        if (this.maxTermOccurrences != other.maxTermOccurrences) {
            return false;
        }
        if (this.maxTokenLength != other.maxTokenLength) {
            return false;
        }
        return this.maxTokenizeLength == other.maxTokenizeLength;
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.language.hashCode(), this.stemMode.hashCode(), this.removeAccents, this.lowercase, this.maxTermOccurrences, this.maxTokenLength, this.maxTokenizeLength);
    }

    static {
        IlscriptsConfig defaults = new IlscriptsConfig(new IlscriptsConfig.Builder());
        DEFAULT_MAX_TERM_OCCURRENCES = defaults.maxtermoccurrences();
        DEFAULT_MAX_TOKEN_LENGTH = defaults.maxtokenlength();
        DEFAULT_MAX_TOKENIZE_LENGTH = defaults.fieldmatchmaxlength();
    }
}

