/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage;

import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.Field;
import com.yahoo.document.fieldpathupdate.FieldPathUpdate;
import com.yahoo.document.update.FieldUpdate;
import com.yahoo.document.update.ValueUpdate;
import com.yahoo.vespa.indexinglanguage.DocumentFieldValues;
import com.yahoo.vespa.indexinglanguage.FieldPathUpdateHelper;
import com.yahoo.vespa.indexinglanguage.FieldUpdateFieldValues;
import com.yahoo.vespa.indexinglanguage.FieldUpdateHelper;
import com.yahoo.vespa.indexinglanguage.IdentityFieldPathUpdateFieldValues;
import com.yahoo.vespa.indexinglanguage.SimpleDocumentFieldValues;
import com.yahoo.vespa.indexinglanguage.UpdateFieldValues;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import java.util.ArrayList;
import java.util.List;

public class FieldValuesFactory {
    private final SelectExpression expressionSelector;

    public FieldValuesFactory() {
        this(new SelectExpression());
    }

    public FieldValuesFactory(SelectExpression expressionSelector) {
        this.expressionSelector = expressionSelector;
    }

    public DocumentFieldValues asFieldValues(Document doc) {
        return FieldValuesFactory.newDocumentAdapter(doc, false);
    }

    public static DocumentFieldValues newDocumentAdapter(Document doc, boolean isUpdate) {
        if (isUpdate) {
            return new SimpleDocumentFieldValues(doc);
        }
        return new SimpleDocumentFieldValues(doc, doc);
    }

    public List<UpdateFieldValues> asFieldValues(DocumentUpdate update) {
        ArrayList<UpdateFieldValues> ret = new ArrayList<UpdateFieldValues>();
        DocumentType docType = update.getDocumentType();
        DocumentId docId = update.getId();
        Document complete = new Document(docType, update.getId());
        for (FieldPathUpdate fieldUpd : update) {
            try {
                if (FieldPathUpdateHelper.isComplete(fieldUpd)) {
                    FieldPathUpdateHelper.applyUpdate(fieldUpd, complete);
                    continue;
                }
                ret.add(new IdentityFieldPathUpdateFieldValues(fieldUpd, FieldValuesFactory.newDocumentAdapter(complete, true)));
            }
            catch (NullPointerException e) {
                throw new IllegalArgumentException("Exception during handling of update '" + String.valueOf(fieldUpd) + "' to field '" + String.valueOf(fieldUpd.getFieldPath()) + "'", e);
            }
        }
        for (FieldUpdate fieldUpdate : update.fieldUpdates()) {
            Field field = fieldUpdate.getField();
            for (ValueUpdate valueUpdate : fieldUpdate.getValueUpdates()) {
                try {
                    if (FieldUpdateHelper.isComplete(field, valueUpdate)) {
                        FieldUpdateHelper.applyUpdate(field, valueUpdate, complete);
                        continue;
                    }
                    Document partial = FieldUpdateHelper.newPartialDocument(docType, docId, field, valueUpdate);
                    ret.add(FieldUpdateFieldValues.fromPartialUpdate(this.expressionSelector.selectExpression(docType, field.getName()), FieldValuesFactory.newDocumentAdapter(partial, true), valueUpdate));
                }
                catch (NullPointerException e) {
                    throw new IllegalArgumentException("Exception during handling of update '" + String.valueOf(valueUpdate) + "' to field '" + String.valueOf(field) + "'", e);
                }
            }
        }
        ret.add(FieldUpdateFieldValues.fromCompleteUpdate(FieldValuesFactory.newDocumentAdapter(complete, true)));
        return ret;
    }

    public static class SelectExpression {
        public Expression selectExpression(DocumentType documentType, String fieldName) {
            return null;
        }
    }
}

