/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import java.time.Instant;

public class ToEpochSecondExpression
extends Expression {
    @Override
    public DataType setInputType(DataType input, VerificationContext context) {
        super.setInputType(input, (DataType)DataType.STRING, context);
        return DataType.LONG;
    }

    @Override
    public DataType setOutputType(DataType output, VerificationContext context) {
        super.setOutputType((DataType)DataType.LONG, output, null, context);
        return DataType.STRING;
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        String inputString = String.valueOf(context.getCurrentValue());
        long epochTime = Instant.parse(inputString).getEpochSecond();
        context.setCurrentValue((FieldValue)new LongFieldValue(epochTime));
    }

    public String toString() {
        return "to_epoch_second";
    }

    public boolean equals(Object obj) {
        return obj instanceof ToEpochSecondExpression;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

