/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.collections.Pair;
import com.yahoo.document.DataType;
import com.yahoo.document.DocumentType;
import com.yahoo.document.Field;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.expressions.AnyDataType;
import com.yahoo.vespa.indexinglanguage.expressions.CompositeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import com.yahoo.vespa.objects.ObjectOperation;
import com.yahoo.vespa.objects.ObjectPredicate;
import com.yahoo.vespa.objects.Selectable;
import java.util.Collections;
import java.util.List;

public final class SelectInputExpression
extends CompositeExpression {
    private final List<Pair<String, Expression>> cases;

    @SafeVarargs
    public SelectInputExpression(Pair<String, Expression> ... cases) {
        this(List.of(cases));
    }

    public SelectInputExpression(List<Pair<String, Expression>> cases) {
        this.cases = cases;
    }

    @Override
    public boolean requiresInput() {
        return false;
    }

    @Override
    public SelectInputExpression convertChildren(ExpressionConverter converter) {
        return new SelectInputExpression(this.cases.stream().map(c -> new Pair((Object)((String)c.getFirst()), (Object)converter.branch().convert((Expression)((Object)((Object)c.getSecond()))))).toList());
    }

    @Override
    public DataType setInputType(DataType inputType, VerificationContext context) {
        super.setInputType(inputType, context);
        DataType outputType = null;
        boolean outputNeverAssigned = true;
        for (Pair<String, Expression> entry : this.cases) {
            DataType fieldType = context.getFieldType((String)entry.getFirst(), this);
            if (fieldType == null) {
                throw new VerificationException(this, "Field '" + (String)entry.getFirst() + "' not found");
            }
            DataType entryOutputType = ((Expression)((Object)entry.getSecond())).setInputType(fieldType, context);
            outputType = outputNeverAssigned ? entryOutputType : this.mostGeneralOf(outputType, entryOutputType);
            outputNeverAssigned = false;
        }
        return outputType;
    }

    @Override
    public DataType setOutputType(DataType outputType, VerificationContext context) {
        super.setOutputType(outputType, context);
        for (Pair<String, Expression> entry : this.cases) {
            DataType fieldType = context.getFieldType((String)entry.getFirst(), this);
            if (fieldType == null) {
                throw new VerificationException(this, "Field '" + (String)entry.getFirst() + "' not found");
            }
            DataType inputType = ((Expression)((Object)entry.getSecond())).setOutputType(outputType, context);
            if (fieldType.isAssignableTo(inputType)) continue;
            throw new VerificationException(this, "Field '" + (String)entry.getFirst() + "' not found");
        }
        return AnyDataType.instance;
    }

    @Override
    public void setStatementOutput(DocumentType documentType, Field field) {
        for (Pair<String, Expression> casePair : this.cases) {
            ((Expression)((Object)casePair.getSecond())).setStatementOutput(documentType, field);
        }
    }

    @Override
    protected void doVerify(VerificationContext context) {
        for (Pair<String, Expression> entry : this.cases) {
            context.verify((Expression)((Object)entry.getSecond()));
        }
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        FieldValue input = context.getCurrentValue();
        for (Pair<String, Expression> entry : this.cases) {
            FieldValue val = context.getFieldValue((String)entry.getFirst());
            if (val == null) continue;
            context.setCurrentValue(val).execute((Expression)((Object)entry.getSecond()));
            break;
        }
        context.setCurrentValue(input);
    }

    public void selectMembers(ObjectPredicate predicate, ObjectOperation operation) {
        for (Pair<String, Expression> entry : this.cases) {
            SelectInputExpression.select((Selectable)((Selectable)entry.getSecond()), (ObjectPredicate)predicate, (ObjectOperation)operation);
        }
    }

    public List<Pair<String, Expression>> getCases() {
        return Collections.unmodifiableList(this.cases);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("select_input { ");
        for (Pair<String, Expression> entry : this.cases) {
            ret.append((String)entry.getFirst()).append(": ");
            Expression exp = (Expression)((Object)entry.getSecond());
            ret.append((Object)exp).append("; ");
        }
        ret.append("}");
        return ret.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SelectInputExpression)) {
            return false;
        }
        SelectInputExpression rhs = (SelectInputExpression)((Object)obj);
        return this.cases.equals(rhs.cases);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + this.cases.hashCode();
    }
}

