/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.AnyDataType;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;

public final class RandomExpression
extends Expression {
    private final Integer max;

    public RandomExpression() {
        this(null);
    }

    public RandomExpression(Integer max) {
        this.max = max;
    }

    @Override
    public boolean requiresInput() {
        return false;
    }

    public Integer getMaxValue() {
        return this.max;
    }

    @Override
    public DataType setInputType(DataType inputType, VerificationContext context) {
        super.setInputType(inputType, context);
        return DataType.INT;
    }

    @Override
    public DataType setOutputType(DataType outputType, VerificationContext context) {
        super.setOutputType((DataType)DataType.INT, outputType, null, context);
        return AnyDataType.instance;
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        int max = Objects.requireNonNullElseGet(this.max, () -> Integer.parseInt(String.valueOf(context.getCurrentValue())));
        context.setCurrentValue((FieldValue)new IntegerFieldValue(ThreadLocalRandom.current().nextInt(max)));
    }

    public String toString() {
        return "random" + (String)(this.max != null ? " " + this.max : "");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RandomExpression)) {
            return false;
        }
        RandomExpression rhs = (RandomExpression)((Object)obj);
        return Objects.equals(this.max, rhs.max);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

