/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.Array;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.text.StringUtilities;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import java.util.Iterator;

public final class JoinExpression
extends Expression {
    private final String delimiter;

    public JoinExpression(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    @Override
    public DataType setInputType(DataType inputType, VerificationContext context) {
        super.setInputType(inputType, context);
        if (inputType == null) {
            return null;
        }
        if (!(inputType instanceof ArrayDataType)) {
            throw new VerificationException(this, "Expected Array input, got type " + inputType.getName());
        }
        return DataType.STRING;
    }

    @Override
    public DataType setOutputType(DataType outputType, VerificationContext context) {
        super.setOutputType((DataType)DataType.STRING, outputType, null, context);
        return this.getInputType(context);
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        FieldValue input = context.getCurrentValue();
        if (!(input instanceof Array)) {
            throw new IllegalArgumentException("Expected Array input, got " + input.getDataType().getName());
        }
        StringBuilder output = new StringBuilder();
        Iterator it = ((Array)input).fieldValueIterator();
        while (it.hasNext()) {
            output.append(it.next());
            if (!it.hasNext()) continue;
            output.append(this.delimiter);
        }
        context.setCurrentValue((FieldValue)new StringFieldValue(output.toString()));
    }

    public String toString() {
        return "join \"" + StringUtilities.escape((String)this.delimiter, (char)'\"') + "\"";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JoinExpression)) {
            return false;
        }
        JoinExpression rhs = (JoinExpression)((Object)obj);
        return this.delimiter.equals(rhs.delimiter);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + this.delimiter.hashCode();
    }
}

