/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.indexinglanguage.expressions.AnyDataType;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;

public final class HostNameExpression
extends Expression {
    @Override
    public boolean requiresInput() {
        return false;
    }

    @Override
    public DataType setInputType(DataType inputType, VerificationContext context) {
        super.setInputType(inputType, context);
        return DataType.STRING;
    }

    @Override
    public DataType setOutputType(DataType outputType, VerificationContext context) {
        super.setOutputType((DataType)DataType.STRING, outputType, null, context);
        return AnyDataType.instance;
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        context.setCurrentValue((FieldValue)new StringFieldValue(HostNameExpression.normalizeHostName(Defaults.getDefaults().vespaHostname())));
    }

    public String toString() {
        return "hostname";
    }

    public boolean equals(Object obj) {
        return obj instanceof HostNameExpression;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    public static String normalizeHostName(String hostName) {
        int pos = hostName.indexOf(46);
        return pos < 0 ? hostName : hostName.substring(0, pos);
    }
}

