/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import java.math.BigInteger;

public final class HexDecodeExpression
extends Expression {
    private static final BigInteger ULONG_MAX = new BigInteger("18446744073709551616");

    @Override
    public DataType setInputType(DataType inputType, VerificationContext context) {
        super.setInputType(inputType, (DataType)DataType.STRING, context);
        return DataType.LONG;
    }

    @Override
    public DataType setOutputType(DataType outputType, VerificationContext context) {
        super.setOutputType((DataType)DataType.LONG, outputType, null, context);
        return DataType.STRING;
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        BigInteger output;
        String input = String.valueOf(context.getCurrentValue());
        if (input.isEmpty()) {
            context.setCurrentValue((FieldValue)new LongFieldValue(Long.MIN_VALUE));
            return;
        }
        try {
            output = new BigInteger(input, 16);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Illegal hex value '" + input + "'");
        }
        if (output.bitLength() > 64) {
            throw new NumberFormatException("Hex value '" + input + "' is out of range");
        }
        if (output.compareTo(BigInteger.ZERO) > 0 && output.bitLength() == 64) {
            output = output.subtract(ULONG_MAX);
        }
        context.setCurrentValue((FieldValue)new LongFieldValue(output.longValue()));
    }

    public String toString() {
        return "hexdecode";
    }

    public boolean equals(Object obj) {
        return obj instanceof HexDecodeExpression;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

