/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.DocumentType;
import com.yahoo.document.Field;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.ExpressionVisitor;
import com.yahoo.vespa.indexinglanguage.UpdateAdapter;
import com.yahoo.vespa.indexinglanguage.expressions.CompositeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.InputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.SetLanguageExpression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.objects.ObjectOperation;
import com.yahoo.vespa.objects.ObjectPredicate;
import com.yahoo.vespa.objects.Selectable;

public final class GuardExpression
extends CompositeExpression {
    private final Expression innerExpression;
    private final boolean shouldExecute;

    public GuardExpression(Expression innerExpression) {
        this.innerExpression = innerExpression;
        this.shouldExecute = GuardExpression.shouldExecute(innerExpression);
    }

    @Override
    public boolean isMutating() {
        return this.innerExpression.isMutating();
    }

    @Override
    public boolean requiresInput() {
        return this.innerExpression.requiresInput();
    }

    public Expression getInnerExpression() {
        return this.innerExpression;
    }

    @Override
    public GuardExpression convertChildren(ExpressionConverter converter) {
        return new GuardExpression(converter.convert(this.innerExpression));
    }

    @Override
    public DataType setInputType(DataType inputType, VerificationContext context) {
        super.setInputType(inputType, context);
        return this.innerExpression.setInputType(inputType, context);
    }

    @Override
    public DataType setOutputType(DataType outputType, VerificationContext context) {
        super.setOutputType(outputType, context);
        return this.innerExpression.setOutputType(outputType, context);
    }

    @Override
    protected void doVerify(VerificationContext context) {
        this.innerExpression.verify(context);
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        if (!this.shouldExecute && context.getFieldValue() instanceof UpdateAdapter) {
            context.setCurrentValue(null);
        } else {
            this.innerExpression.execute(context);
        }
    }

    @Override
    public void setStatementOutput(DocumentType documentType, Field field) {
        this.innerExpression.setStatementOutput(documentType, field);
    }

    public String toString() {
        return "guard " + GuardExpression.toScriptBlock(this.innerExpression);
    }

    public void selectMembers(ObjectPredicate predicate, ObjectOperation operation) {
        GuardExpression.select((Selectable)this.innerExpression, (ObjectPredicate)predicate, (ObjectOperation)operation);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GuardExpression)) {
            return false;
        }
        GuardExpression rhs = (GuardExpression)((Object)obj);
        return ((Object)((Object)this.innerExpression)).equals((Object)rhs.innerExpression);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + ((Object)((Object)this.innerExpression)).hashCode();
    }

    private static boolean shouldExecute(Expression exp) {
        ExecutionGuard guard = new ExecutionGuard();
        guard.visit(exp);
        return guard.shouldExecute;
    }

    private static class ExecutionGuard
    extends ExpressionVisitor {
        boolean shouldExecute = false;

        private ExecutionGuard() {
        }

        @Override
        protected void doVisit(Expression exp) {
            if (exp instanceof InputExpression || exp instanceof SetLanguageExpression) {
                this.shouldExecute = true;
            }
        }
    }
}

